"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SPLUNK_RULES_COLUMNS = exports.SPLUNK_MACROS_COLUMNS = exports.RULES_SPLUNK_QUERY = exports.MACROS_SPLUNK_QUERY = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SPLUNK_RULES_COLUMNS = exports.SPLUNK_RULES_COLUMNS = ['id', 'title', 'search', 'description', 'action.escu.eli5', 'action.correlationsearch.annotations', 'alert.severity'];
const RULES_SPLUNK_QUERY = exports.RULES_SPLUNK_QUERY = `| rest /servicesNS/-/-/saved/searches
| search action.correlationsearch.enabled = "1" OR (eai:acl.app = "Splunk_Security_Essentials" AND is_scheduled=1)
| where disabled=0
| table ${SPLUNK_RULES_COLUMNS.join(', ')}`;
const SPLUNK_MACROS_COLUMNS = exports.SPLUNK_MACROS_COLUMNS = ['title', 'definition'];
const MACROS_SPLUNK_QUERY = exports.MACROS_SPLUNK_QUERY = `| rest /servicesNS/-/-/admin/macros count=0
| table ${SPLUNK_MACROS_COLUMNS.join(', ')}`;