"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDeleteMigration = exports.DELETE_MIGRATION_SUCCESS = exports.DELETE_MIGRATION_RULE_MUTATION_KEY = exports.DELETE_MIGRATION_FAILURE = void 0;
var _react = require("react");
var _reactQuery = require("@tanstack/react-query");
var _i18n = require("@kbn/i18n");
var _kibana_react = require("../../../common/lib/kibana/kibana_react");
var _constants = require("../../../../common/siem_migrations/constants");
var _use_app_toasts = require("../../../common/hooks/use_app_toasts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DELETE_MIGRATION_SUCCESS = exports.DELETE_MIGRATION_SUCCESS = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.common.deleteMigrationSuccess', {
  defaultMessage: 'Migration deleted'
});
const DELETE_MIGRATION_FAILURE = exports.DELETE_MIGRATION_FAILURE = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.common.deleteMigrationFailDescription', {
  defaultMessage: 'Failed to delete migration'
});
const DELETE_MIGRATION_RULE_MUTATION_KEY = exports.DELETE_MIGRATION_RULE_MUTATION_KEY = ['DELETE', _constants.SIEM_RULE_MIGRATION_PATH];
const useDeleteMigration = migrationType => {
  const {
    addError,
    addSuccess
  } = (0, _use_app_toasts.useAppToasts)();
  const {
    siemMigrations
  } = (0, _kibana_react.useKibana)().services;
  const deleteMigration = (0, _react.useCallback)(migrationId => {
    if (migrationType === 'rule') {
      return siemMigrations.rules.deleteMigration(migrationId);
    } else {
      return siemMigrations.dashboards.deleteMigration(migrationId);
    }
  }, [siemMigrations, migrationType]);
  return (0, _reactQuery.useMutation)({
    mutationFn: migrationId => deleteMigration(migrationId),
    onSuccess: () => {
      addSuccess(DELETE_MIGRATION_SUCCESS);
    },
    onError: error => {
      addError(error, {
        title: DELETE_MIGRATION_FAILURE
      });
    }
  });
};
exports.useDeleteMigration = useDeleteMigration;