"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorSetup = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _add_connector_modal = require("@kbn/elastic-assistant/impl/connectorland/add_connector_modal");
var i18n = _interopRequireWildcard(require("./translations"));
var _kibana = require("../../../../../../common/lib/kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/onboarding/components/onboarding_body/cards/common/connectors/connector_setup.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ConnectorSetup = exports.ConnectorSetup = /*#__PURE__*/_react.default.memo(({
  onConnectorSaved,
  actionTypes
}) => {
  const [isModalVisible, setIsModalVisible] = (0, _react.useState)(false);
  const [selectedActionType, setSelectedActionType] = (0, _react.useState)(null);
  const {
    actionTypeRegistry
  } = (0, _kibana.useKibana)().services.triggersActionsUi;
  const onModalClose = (0, _react.useCallback)(() => {
    setSelectedActionType(null);
    setIsModalVisible(false);
  }, []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    css: {
      height: '100%'
    },
    direction: "column",
    justifyContent: "center",
    alignItems: "center",
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    justifyContent: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 15
    }
  }, actionTypes.map(actionType => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    key: actionType.id,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "center",
    justifyContent: "center",
    gutterSize: "s",
    className: (0, _css.css)`
                        height: 100%;
                      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "xxl",
    color: "text",
    type: actionTypeRegistry.get(actionType.id).iconClass,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 25
    }
  }))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "createConnectorButton",
    iconType: "plusInCircle",
    iconSide: "left",
    onClick: () => setIsModalVisible(true),
    isLoading: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 15
    }
  }, i18n.CREATE_NEW_CONNECTOR_BUTTON)))), isModalVisible && /*#__PURE__*/_react.default.createElement(_add_connector_modal.AddConnectorModal, {
    actionTypeRegistry: actionTypeRegistry,
    actionTypes: actionTypes,
    onClose: onModalClose,
    onSaveConnector: onConnectorSaved,
    onSelectActionType: setSelectedActionType,
    selectedActionType: selectedActionType,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 11
    }
  }));
});
ConnectorSetup.displayName = 'ConnectorSetup';