"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.AssistantCard = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _elasticAssistant = require("@kbn/elastic-assistant");
var _use_current_conversation = require("@kbn/elastic-assistant/impl/assistant/use_current_conversation");
var _use_data_stream_apis = require("@kbn/elastic-assistant/impl/assistant/use_data_stream_apis");
var _helpers = require("@kbn/elastic-assistant/impl/assistant/helpers");
var _helpers2 = require("@kbn/elastic-assistant/impl/connectorland/helpers");
var _use_conversation = require("@kbn/elastic-assistant/impl/assistant/use_conversation");
var _centered_loading_spinner = require("../../../../../common/components/centered_loading_spinner");
var i18n = _interopRequireWildcard(require("./translations"));
var _missing_privileges = require("../common/connectors/missing_privileges");
var _use_stored_state = require("../../../hooks/use_stored_state");
var _onboarding_context = require("../../../onboarding_context");
var _card_content_panel = require("../common/card_content_panel");
var _connector_cards = require("../common/connectors/connector_cards");
var _card_subdued_text = require("../common/card_subdued_text");
var _ai_feature_message = require("./ai_feature_message");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/onboarding/components/onboarding_body/cards/assistant/assistant_card.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AssistantCard = ({
  isCardComplete,
  setExpandedCardId,
  checkCompleteMetadata,
  checkComplete,
  isCardAvailable
}) => {
  const {
    spaceId
  } = (0, _onboarding_context.useOnboardingContext)();
  const {
    connectors,
    canExecuteConnectors,
    canCreateConnectors
  } = checkCompleteMetadata !== null && checkCompleteMetadata !== void 0 ? checkCompleteMetadata : {};
  const [selectedConnectorId, setSelectedConnectorId] = (0, _use_stored_state.useStoredAssistantConnectorId)(spaceId);
  const {
    http,
    assistantAvailability: {
      isAssistantEnabled
    },
    settings
  } = (0, _elasticAssistant.useAssistantContext)();
  const defaultConnector = (0, _react.useMemo)(() => (0, _helpers.getDefaultConnector)(connectors, settings), [connectors, settings]);
  const {
    setApiConfig
  } = (0, _use_conversation.useConversation)();
  const {
    getLastConversation,
    setLastConversation
  } = (0, _elasticAssistant.useAssistantLastConversation)({
    spaceId
  });
  const {
    allSystemPrompts,
    conversations,
    isFetchedCurrentUserConversations,
    isFetchedPrompts,
    refetchCurrentUserConversations
  } = (0, _use_data_stream_apis.useDataStreamApis)({
    http,
    isAssistantEnabled
  });
  const {
    currentConversation,
    handleOnConversationSelected
  } = (0, _use_current_conversation.useCurrentConversation)({
    allSystemPrompts,
    conversations,
    defaultConnector,
    spaceId,
    refetchCurrentUserConversations,
    lastConversation: getLastConversation(),
    mayUpdateConversations: isFetchedCurrentUserConversations && isFetchedPrompts && Object.keys(conversations).length > 0,
    setLastConversation
  });
  const onConversationChange = (0, _react.useCallback)(updatedConversation => {
    handleOnConversationSelected({
      cId: updatedConversation.id,
      cTitle: updatedConversation.title
    });
  }, [handleOnConversationSelected]);
  const onConnectorSelected = (0, _react.useCallback)(async connector => {
    const connectorId = connector.id;
    const config = (0, _helpers2.getGenAiConfig)(connector);
    const apiProvider = config === null || config === void 0 ? void 0 : config.apiProvider;
    const model = config === null || config === void 0 ? void 0 : config.defaultModel;
    if (currentConversation != null) {
      const conversation = await setApiConfig({
        conversation: currentConversation,
        apiConfig: {
          ...currentConversation.apiConfig,
          actionTypeId: connector.actionTypeId,
          connectorId,
          // With the inline component, prefer config args to handle 'new connector' case
          provider: apiProvider,
          model
        }
      }).catch(() => {
        // If the conversation is not found, it means the connector was deleted
        // and return null to avoid setting the conversation
        return null;
      });
      if (conversation && onConversationChange != null) {
        onConversationChange(conversation);
      }
    }
    if (connector) {
      setSelectedConnectorId(connectorId);
    }
  }, [currentConversation, setApiConfig, onConversationChange, setSelectedConnectorId]);
  const isEISConnectorAvailable = (0, _react.useMemo)(() => {
    var _connectors$some;
    return (_connectors$some = connectors === null || connectors === void 0 ? void 0 : connectors.some(c => (0, _helpers2.isElasticManagedLlmConnector)(c))) !== null && _connectors$some !== void 0 ? _connectors$some : false;
  }, [connectors]);
  if (!checkCompleteMetadata) {
    return /*#__PURE__*/_react.default.createElement(_card_content_panel.OnboardingCardContentPanel, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 138,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_centered_loading_spinner.CenteredLoadingSpinner, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 139,
        columnNumber: 9
      }
    }));
  }
  const onNewConnectorSaved = connectorId => {
    checkComplete();
    setSelectedConnectorId(connectorId);
  };
  return /*#__PURE__*/_react.default.createElement(_card_content_panel.OnboardingCardContentPanel, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 5
    }
  }, canExecuteConnectors ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_card_subdued_text.CardSubduedText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 13
    }
  }, isEISConnectorAvailable ? /*#__PURE__*/_react.default.createElement(_ai_feature_message.ElasticAIFeatureMessage, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 17
    }
  }) : i18n.ASSISTANT_CARD_DESCRIPTION)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_connector_cards.ConnectorCards, {
    canCreateConnectors: canCreateConnectors,
    connectors: connectors,
    onNewConnectorSaved: onNewConnectorSaved,
    selectedConnectorId: selectedConnectorId,
    onConnectorSelected: onConnectorSelected,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 13
    }
  }))) : /*#__PURE__*/_react.default.createElement(_missing_privileges.ConnectorsMissingPrivilegesCallOut, {
    level: "read",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 9
    }
  }));
};

// eslint-disable-next-line import/no-default-export
exports.AssistantCard = AssistantCard;
var _default = exports.default = AssistantCard;