"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkflowInsightsScanSection = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _lodash = require("lodash");
var _fp = require("lodash/fp");
var _eui = require("@elastic/eui");
var _elastic_llm = require("@kbn/elastic-assistant/impl/tour/elastic_llm");
var _const = require("@kbn/elastic-assistant/impl/tour/const");
var _setup_knowledge_base_button = require("@kbn/elastic-assistant/impl/knowledge_base/setup_knowledge_base_button");
var _elasticAssistant = require("@kbn/elastic-assistant");
var _i18nReact = require("@kbn/i18n-react");
var _user_privileges = require("../../../../../../../common/components/user_privileges");
var _use_space_id = require("../../../../../../../common/hooks/use_space_id");
var _translations = require("../../../translations");
var _kibana = require("../../../../../../../common/lib/kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/endpoint_hosts/view/details/components/insights/workflow_insights_scan.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const WorkflowInsightsScanSection = ({
  isScanButtonDisabled,
  onScanButtonClick,
  inferenceEnabled,
  kbStatus,
  defendInsightsPolicyResponseFailureEnabled
}) => {
  const CONNECTOR_ID_LOCAL_STORAGE_KEY = 'connectorId';
  const spaceId = (0, _use_space_id.useSpaceId)();
  const {
    http,
    settings,
    docLinks
  } = (0, _kibana.useKibana)().services;
  const {
    data: aiConnectors
  } = (0, _elasticAssistant.useLoadConnectors)({
    http,
    settings
  });
  const {
    canWriteWorkflowInsights
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  const {
    setupKB,
    setupOngoing,
    docsLinkText
  } = _translations.WORKFLOW_INSIGHTS.knowledgeBase;

  // Store the selected connector id in local storage so that it persists across page reloads
  const [localStorageWorkflowInsightsConnectorId, setLocalStorageWorkflowInsightsConnectorId] = (0, _useLocalStorage.default)(`${_elasticAssistant.DEFAULT_ASSISTANT_NAMESPACE}.${_elasticAssistant.DEFEND_INSIGHTS_STORAGE_KEY}.${spaceId || 'default'}.${CONNECTOR_ID_LOCAL_STORAGE_KEY}`);
  const [connectorId, setConnectorId] = _react.default.useState(localStorageWorkflowInsightsConnectorId);
  const onConnectorIdSelected = (0, _react.useCallback)(selectedConnectorId => {
    setConnectorId(selectedConnectorId);
    setLocalStorageWorkflowInsightsConnectorId(selectedConnectorId);
  }, [setLocalStorageWorkflowInsightsConnectorId]);

  // Check if the selected connector exists in the list of connectors, i.e. it is not deleted
  const connectorExists = (0, _react.useMemo)(() => (0, _lodash.some)(aiConnectors, ['id', connectorId]), [aiConnectors, connectorId]);
  const selectedConnectorActionTypeId = (0, _react.useMemo)(() => {
    const selectedConnector = aiConnectors === null || aiConnectors === void 0 ? void 0 : aiConnectors.find(connector => connector.id === connectorId);
    return selectedConnector === null || selectedConnector === void 0 ? void 0 : selectedConnector.actionTypeId;
  }, [aiConnectors, connectorId]);

  // Render the scan button only if a connector is selected
  const scanButton = (0, _react.useMemo)(() => {
    if (!connectorExists) {
      return null;
    }
    const button = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 111,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "workflowInsightsScanButton",
      size: "s",
      isLoading: isScanButtonDisabled,
      isDisabled: !canWriteWorkflowInsights,
      onClick: () => {
        if (!connectorId || !selectedConnectorActionTypeId) return;
        onScanButtonClick({
          connectorId,
          actionTypeId: selectedConnectorActionTypeId
        });
      },
      fill: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 9
      }
    }, isScanButtonDisabled ? _translations.WORKFLOW_INSIGHTS.scan.loading : _translations.WORKFLOW_INSIGHTS.scan.button));
    if (!canWriteWorkflowInsights) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: _translations.WORKFLOW_INSIGHTS.scan.noPermissions,
        position: 'top',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 130,
          columnNumber: 9
        }
      }, button);
    }
    return button;
  }, [canWriteWorkflowInsights, connectorExists, connectorId, isScanButtonDisabled, onScanButtonClick, selectedConnectorActionTypeId]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "m",
    hasShadow: false,
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "sparkles",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 19
    }
  }, _translations.WORKFLOW_INSIGHTS.scan.title))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 15
    }
  }, spaceId && /*#__PURE__*/_react.default.createElement(_elasticAssistant.AssistantSpaceIdProvider, {
    spaceId: spaceId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_elastic_llm.ElasticLLMCostAwarenessTour, {
    isDisabled: !inferenceEnabled,
    selectedConnectorId: connectorId,
    zIndex: 1000,
    storageKey: _const.NEW_FEATURES_TOUR_STORAGE_KEYS.ELASTIC_LLM_USAGE_AUTOMATIC_TROUBLESHOOTING,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_elasticAssistant.ConnectorSelectorInline, {
    onConnectorSelected: _fp.noop,
    onConnectorIdSelected: onConnectorIdSelected,
    selectedConnectorId: connectorId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 23
    }
  })))), scanButton))), defendInsightsPolicyResponseFailureEnabled && !!kbStatus && !(kbStatus !== null && kbStatus !== void 0 && kbStatus.defend_insights_exists) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "center",
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 17
    }
  }, kbStatus !== null && kbStatus !== void 0 && kbStatus.is_setup_in_progress ? setupOngoing : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpointDetails.workflowInsights.knowledgeBase.setupRequired",
    defaultMessage: "This scan is for incompatible antiviruses. To also scan for Policy Response issues, you should first {setupKB}. This may take a while.",
    values: {
      setupKB: /*#__PURE__*/_react.default.createElement("b", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 199,
          columnNumber: 42
        }
      }, setupKB)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 21
    }
  }), !(kbStatus !== null && kbStatus !== void 0 && kbStatus.is_setup_in_progress) && /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: docLinks.links.securitySolution.aiAssistant.knowledgeBaseHome,
    target: "_blank",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 21
    }
  }, ` ${docsLinkText}`))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_setup_knowledge_base_button.SetupKnowledgeBaseButton, {
    fill: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 17
    }
  })))));
};
exports.WorkflowInsightsScanSection = WorkflowInsightsScanSection;