"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BackToPolicyListButton = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _kibana = require("../../../../../common/lib/kibana");
var _back_to_external_app_button = require("../../../../components/back_to_external_app_button/back_to_external_app_button");
var _routing = require("../../../../common/routing");
var _common = require("../../../../../../common");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/endpoint_hosts/view/components/back_to_policy_list_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const BackToPolicyListButton = exports.BackToPolicyListButton = /*#__PURE__*/(0, _react.memo)(({
  backLink
}) => {
  const {
    getAppUrl
  } = (0, _kibana.useAppUrl)();
  const backLinkOptions = (0, _react.useMemo)(() => {
    if (backLink) {
      const {
        navigateTo,
        label,
        href
      } = backLink;
      return {
        onBackButtonNavigateTo: navigateTo,
        backButtonLabel: label,
        backButtonUrl: href
      };
    }

    // the default back button is to the policy list
    const policyListPath = (0, _routing.getPoliciesPath)();
    return {
      backButtonLabel: _i18n.i18n.translate('xpack.securitySolution.endpoint.list.backToPolicyButton', {
        defaultMessage: 'Back to policy list'
      }),
      backButtonUrl: getAppUrl({
        path: policyListPath
      }),
      onBackButtonNavigateTo: [_common.APP_UI_ID, {
        path: policyListPath
      }]
    };
  }, [getAppUrl, backLink]);
  if (!backLink) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_back_to_external_app_button.BackToExternalAppButton, (0, _extends2.default)({}, backLinkOptions, {
    "data-test-subj": "endpointListBackLink",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 12
    }
  }));
});
BackToPolicyListButton.displayName = 'BackToPolicyListButton';