"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSummaryArtifact = useSummaryArtifact;
var _reactQuery = require("@tanstack/react-query");
var _utils = require("../../common/utils");
var _constants = require("../../../../common/endpoint/service/artifacts/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_OPTIONS = Object.freeze({});
function useSummaryArtifact(exceptionListApiClient, options = DEFAULT_OPTIONS, searchableFields = _constants.DEFAULT_EXCEPTION_LIST_ITEM_SEARCHABLE_FIELDS, customQueryOptions) {
  const {
    filter = '',
    policies = []
  } = options;
  return (0, _reactQuery.useQuery)(['summary', exceptionListApiClient, filter, policies], () => {
    return exceptionListApiClient.summary((0, _utils.parsePoliciesAndFilterToKql)({
      policies,
      kuery: (0, _utils.parseQueryFilterToKQL)(filter, searchableFields)
    }));
  }, customQueryOptions);
}