"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTabs = void 0;
var _react = require("react");
var _entity_details_flyout = require("../../../entity_analytics/components/entity_details_flyout");
var _types = require("../../../../common/entity_analytics/types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useTabs = (name, scopeId) => (0, _react.useMemo)(() => {
  return [(0, _entity_details_flyout.getRiskInputTab)({
    entityName: name,
    entityType: _types.EntityType.service,
    scopeId
  })];
}, [name, scopeId]);
exports.useTabs = useTabs;