"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTabs = exports.useSelectedTab = void 0;
var _react = require("react");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _types = require("../../../../common/entity_analytics/types");
var _entity_details_flyout = require("../../../entity_analytics/components/entity_details_flyout");
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSelectedTab = (params, tabs) => {
  const {
    openLeftPanel
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const path = params.path;
  const selectedTabId = (0, _react.useMemo)(() => {
    var _tabs$find$id, _tabs$find;
    const defaultTab = tabs.length > 0 ? tabs[0].id : undefined;
    if (!path) return defaultTab;
    return (_tabs$find$id = (_tabs$find = tabs.find(tab => tab.id === path.tab)) === null || _tabs$find === void 0 ? void 0 : _tabs$find.id) !== null && _tabs$find$id !== void 0 ? _tabs$find$id : defaultTab;
  }, [path, tabs]);
  const setSelectedTabId = tabId => {
    openLeftPanel({
      id: _.HostDetailsPanelKey,
      params: {
        ...params,
        path: {
          tab: tabId
        }
      }
    });
  };
  return {
    setSelectedTabId,
    selectedTabId
  };
};
exports.useSelectedTab = useSelectedTab;
const useTabs = ({
  isRiskScoreExist,
  name,
  scopeId,
  hasMisconfigurationFindings,
  hasVulnerabilitiesFindings,
  hasNonClosedAlerts
}) => {
  return (0, _react.useMemo)(() => {
    const isRiskScoreTabAvailable = isRiskScoreExist && name;
    const riskScoreTab = isRiskScoreTabAvailable ? [(0, _entity_details_flyout.getRiskInputTab)({
      entityName: name,
      entityType: _types.EntityType.host,
      scopeId
    })] : [];

    // Determine if the Insights tab should be included
    const insightsTab = hasMisconfigurationFindings || hasVulnerabilitiesFindings || hasNonClosedAlerts ? [(0, _entity_details_flyout.getInsightsInputTab)({
      name,
      fieldName: _types.EntityIdentifierFields.hostName,
      scopeId
    })] : [];
    return [...riskScoreTab, ...insightsTab];
  }, [isRiskScoreExist, name, scopeId, hasMisconfigurationFindings, hasVulnerabilitiesFindings, hasNonClosedAlerts]);
};
exports.useTabs = useTabs;