"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrivilegedAccessInfoPopover = void 0;
var _eui = require("@elastic/eui");
var _reactHooks = require("@kbn/react-hooks");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _css = require("@emotion/css");
var _use_integration_link_state = require("../../../../../common/hooks/integrations/use_integration_link_state");
var _constants = require("../../../../../../common/constants");
var _integrations = require("../../../../../common/utils/integrations");
var _constants2 = require("../../../../../common/lib/integrations/constants");
var _kibana = require("../../../../../common/lib/kibana");
var _use_integrations = require("../../../privileged_user_monitoring_onboarding/hooks/use_integrations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/privileged_user_monitoring/components/privileged_access_detection/info_popover.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PrivilegedAccessInfoPopover = () => {
  const {
    docLinks
  } = (0, _kibana.useKibana)().services;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [isPopoverOpen, {
    off: closePopover,
    toggle: togglePopover
  }] = (0, _reactHooks.useBoolean)(false);
  const entityAnalyticsLinks = docLinks.links.securitySolution.entityAnalytics;
  const state = (0, _use_integration_link_state.useIntegrationLinkState)(_constants.ENTITY_ANALYTICS_PRIVILEGED_USER_MONITORING_PATH);
  const {
    navigateTo
  } = (0, _kibana.useNavigation)();
  const padPackage = (0, _use_integrations.usePrivilegedAccessDetectionIntegration)();
  const navigateToPadIntegration = (0, _react.useCallback)(() => {
    navigateTo({
      appId: _constants2.INTEGRATION_APP_ID,
      path: (0, _integrations.addPathParamToUrl)(`/detail/${padPackage === null || padPackage === void 0 ? void 0 : padPackage.name}-${padPackage === null || padPackage === void 0 ? void 0 : padPackage.version}/overview`, _constants.ENTITY_ANALYTICS_PRIVILEGED_USER_MONITORING_PATH),
      state
    });
  }, [navigateTo, padPackage, state]);
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "info",
    onClick: togglePopover,
    "aria-label": 'oi',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 18
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    className: (0, _css.css)`
        padding-left: ${euiTheme.size.s};
      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedAccessDetection.infoPopover.title",
    defaultMessage: "Top privileged access anomalies",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    className: (0, _css.css)`
          max-width: 530px;
        `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedAccessDetection.infoPopover.description",
    defaultMessage: "{link} helps to detect anomalous privileged access activity in the Windows, Linux, and Okta system logs.",
    values: {
      link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        onClick: navigateToPadIntegration,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 83,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.entityAnalytics.privilegedAccessDetection.infoPopover.linkText",
        defaultMessage: "The Privileged access detection ML package",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 84,
          columnNumber: 17
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedAccessDetection.infoPopover.swimLanesDescription",
    defaultMessage: "Swim lanes provide an overview of the data buckets analyzed within the selected time period. A swim lane reflects the top 10 privileged users based on their anomaly scores, showing the highest anomaly score for that user in each block.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedAccessDetection.infoPopover.swimLanesColorDescription",
    defaultMessage: "Each block in a swim lane is colored based on its anomaly score (0\u2013100). High scores are shown in red, while low scores are shown in blue.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    target: "_blank",
    rel: "noopener nofollow noreferrer",
    href: entityAnalyticsLinks.mlAnomalyDetection,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedAccessDetection.infoPopover.learnMoreLink",
    defaultMessage: "Learn more about anomaly detection",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 11
    }
  }))));
};
exports.PrivilegedAccessInfoPopover = PrivilegedAccessInfoPopover;