"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertsTreemapPanel = void 0;
var _eui = require("@elastic/eui");
var _esQuery = require("@kbn/es-query");
var _common = require("@kbn/data-plugin/common");
var _react = _interopRequireWildcard(require("react"));
var _uuid = require("uuid");
var _use_global_time = require("../../../../common/containers/use_global_time");
var _alerts_treemap = require("./alerts_treemap");
var _components = require("../common/components");
var _hooks = require("../common/hooks");
var _use_query = require("../../../containers/detection_engine/alerts/use_query");
var _constants = require("../../../containers/detection_engine/alerts/constants");
var _field_selection = require("../common/field_selection");
var _header_section = require("../../../../common/components/header_section");
var _inspect = require("../../../../common/components/inspect");
var _query = require("./alerts_treemap/query");
var _kibana = require("../../../../common/lib/kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detections/components/alerts_kpis/alerts_treemap_panel/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DEFAULT_HEIGHT = _alerts_treemap.DEFAULT_MIN_CHART_HEIGHT + 134; // px

const COLLAPSED_HEIGHT = 64; // px

const ALERTS_TREEMAP_ID = 'alerts-treemap';
const AlertsTreemapPanelComponent = ({
  addFilter,
  alignHeader,
  chartOptionsContextMenu,
  inspectTitle,
  isPanelExpanded,
  filters,
  height = DEFAULT_HEIGHT,
  query,
  riskSubAggregationField,
  runtimeMappings,
  setIsPanelExpanded,
  setStackByField0,
  setStackByField0ComboboxInputRef,
  setStackByField1,
  setStackByField1ComboboxInputRef,
  signalIndexName,
  stackByField0,
  stackByField0ComboboxRef,
  stackByField1,
  stackByField1ComboboxRef,
  stackByWidth,
  title
}) => {
  const {
    to,
    from,
    deleteQuery,
    setQuery
  } = (0, _use_global_time.useGlobalTime)();
  const {
    uiSettings
  } = (0, _kibana.useKibana)().services;

  // create a unique, but stable (across re-renders) query id
  const uniqueQueryId = (0, _react.useMemo)(() => `${ALERTS_TREEMAP_ID}-${(0, _uuid.v4)()}`, []);
  const additionalFilters = (0, _react.useMemo)(() => {
    try {
      var _filters$filter;
      const config = (0, _common.getEsQueryConfig)(uiSettings);
      return [(0, _esQuery.buildEsQuery)(undefined, query != null ? [query] : [], (_filters$filter = filters === null || filters === void 0 ? void 0 : filters.filter(f => f.meta.disabled === false)) !== null && _filters$filter !== void 0 ? _filters$filter : [], config)];
    } catch (e) {
      return [];
    }
  }, [query, filters, uiSettings]);
  const {
    data: alertsData,
    loading: isLoadingAlerts,
    refetch,
    request,
    response,
    setQuery: setAlertsQuery
  } = (0, _use_query.useQueryAlerts)({
    query: (0, _query.getAlertsRiskQuery)({
      additionalFilters,
      from,
      riskSubAggregationField,
      runtimeMappings,
      stackByField0,
      stackByField1,
      to
    }),
    skip: !isPanelExpanded,
    indexName: signalIndexName,
    queryName: _constants.ALERTS_QUERY_NAMES.TREE_MAP
  });
  (0, _react.useEffect)(() => {
    setAlertsQuery((0, _query.getAlertsRiskQuery)({
      additionalFilters,
      from,
      riskSubAggregationField,
      runtimeMappings,
      stackByField0,
      stackByField1,
      to
    }));
  }, [additionalFilters, from, riskSubAggregationField, runtimeMappings, setAlertsQuery, stackByField0, stackByField1, to]);
  (0, _hooks.useInspectButton)({
    deleteQuery,
    loading: isLoadingAlerts,
    response,
    setQuery,
    refetch,
    request,
    uniqueQueryId
  });
  return /*#__PURE__*/_react.default.createElement(_inspect.InspectButtonContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_components.KpiPanel, {
    className: "eui-yScroll",
    "data-test-subj": "treemapPanel",
    hasBorder: true,
    height: isPanelExpanded ? height : COLLAPSED_HEIGHT,
    $overflowY: isPanelExpanded ? 'auto' : 'hidden',
    $toggleStatus: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_header_section.HeaderSection, {
    alignHeader: alignHeader,
    hideSubtitle: true,
    id: uniqueQueryId,
    inspectTitle: inspectTitle,
    outerDirection: "row",
    showInspectButton: chartOptionsContextMenu == null,
    title: title,
    titleSize: "s",
    toggleQuery: setIsPanelExpanded,
    toggleStatus: isPanelExpanded,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 9
    }
  }, isPanelExpanded && /*#__PURE__*/_react.default.createElement(_field_selection.FieldSelection, {
    chartOptionsContextMenu: chartOptionsContextMenu,
    setStackByField0: setStackByField0,
    setStackByField0ComboboxInputRef: setStackByField0ComboboxInputRef,
    setStackByField1: setStackByField1,
    setStackByField1ComboboxInputRef: setStackByField1ComboboxInputRef,
    stackByField0: stackByField0,
    stackByField0ComboboxRef: stackByField0ComboboxRef,
    stackByField1: stackByField1,
    stackByField1ComboboxRef: stackByField1ComboboxRef,
    stackByWidth: stackByWidth,
    uniqueQueryId: uniqueQueryId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 13
    }
  })), isLoadingAlerts && isPanelExpanded ? /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    color: "accent",
    "data-test-subj": "progress",
    position: "absolute",
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, alertsData != null && isPanelExpanded && /*#__PURE__*/_react.default.createElement(_alerts_treemap.AlertsTreemap, {
    addFilter: addFilter,
    data: alertsData,
    maxBuckets: _query.DEFAULT_STACK_BY_FIELD0_SIZE,
    stackByField0: stackByField0,
    stackByField1: stackByField1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 15
    }
  }))));
};
AlertsTreemapPanelComponent.displayName = 'AlertsTreemapPanelComponent';
const AlertsTreemapPanel = exports.AlertsTreemapPanel = /*#__PURE__*/_react.default.memo(AlertsTreemapPanelComponent);