"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PageFilters = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-utils-plugin/public");
var _public2 = require("@kbn/controls-plugin/public");
var _alert_filter_controls = require("@kbn/alerts-ui-shared/src/alert_filter_controls");
var _reactRouterDom = require("react-router-dom");
var _securitysolutionRules = require("@kbn/securitysolution-rules");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _kibana = require("../../../../common/lib/kibana");
var _constants = require("../../../../../common/constants");
var _use_url_state = require("../../../../common/hooks/use_url_state");
var _use_space_id = require("../../../../common/hooks/use_space_id");
var _constants2 = require("../../../constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detections/components/alerts/filters/page_filters.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PageFilters = exports.PageFilters = /*#__PURE__*/(0, _react.memo)(({
  dataView,
  ...props
}) => {
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const {
    http,
    notifications,
    dataViews
  } = (0, _kibana.useKibana)().services;
  const services = (0, _react.useMemo)(() => ({
    http,
    notifications,
    dataViews,
    storage: _public.Storage
  }), [dataViews, http, notifications]);
  const history = (0, _reactRouterDom.useHistory)();
  const urlStorage = (0, _react.useMemo)(() => (0, _public.createKbnUrlStateStorage)({
    history,
    useHash: false,
    useHashQuery: false
  }), [history]);
  const filterControlsUrlState = (0, _react.useMemo)(() => {
    var _urlStorage$get;
    return (_urlStorage$get = urlStorage.get(_use_url_state.URL_PARAM_KEY.pageFilter)) !== null && _urlStorage$get !== void 0 ? _urlStorage$get : undefined;
  }, [urlStorage]);
  const setFilterControlsUrlState = (0, _react.useCallback)(newFilterControls => {
    urlStorage.set(_use_url_state.URL_PARAM_KEY.pageFilter, newFilterControls);
  }, [urlStorage]);

  // TODO change to .getIndexPattern() once we remove the newDataViewPickerEnabled feature flag and we have a DataView object
  const alertsIndicesTitle = (0, _react.useMemo)(() => {
    var _dataView$title;
    return (_dataView$title = dataView.title) === null || _dataView$title === void 0 ? void 0 : _dataView$title.split(',').filter(index => index.includes(_constants.DEFAULT_ALERTS_INDEX)).join(',');
  }, [dataView]);
  const customDataViewSpec = (0, _react.useMemo)(() => ({
    id: _constants2.SECURITY_ALERT_DATA_VIEW.id,
    name: _constants2.SECURITY_ALERT_DATA_VIEW.name,
    allowNoIndex: true,
    title: alertsIndicesTitle,
    timeFieldName: '@timestamp'
  }), [alertsIndicesTitle]);
  const spaceId = (0, _use_space_id.useSpaceId)();
  if (!spaceId) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_alert_filter_controls.AlertFilterControls, (0, _extends2.default)({
    chainingSystem: "HIERARCHICAL",
    ControlGroupRenderer: _public2.ControlGroupRenderer,
    controlsUrlState: filterControlsUrlState,
    dataViewSpec: customDataViewSpec,
    defaultControls: _constants.DEFAULT_DETECTION_PAGE_FILTERS,
    maxControls: 4,
    preventCacheClearOnUnmount: newDataViewPickerEnabled,
    ruleTypeIds: _securitysolutionRules.SECURITY_SOLUTION_RULE_TYPE_IDS,
    services: services,
    setControlsUrlState: setFilterControlsUrlState,
    spaceId: spaceId
  }, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 5
    }
  }));
});
PageFilters.displayName = 'PageFilters';