"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResponseActionsForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _reactMarkdown = _interopRequireDefault(require("react-markdown"));
var _response_actions_wrapper = require("./response_actions_wrapper");
var _response_actions_header = require("./response_actions_header");
var _use_supported_response_action_types = require("./use_supported_response_action_types");
var _constants = require("./constants");
var _translations = require("../../common/components/rule_actions_field/translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_response_actions/response_actions_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ResponseActionsForm = ({
  items,
  addItem,
  removeItem,
  form
}) => {
  const supportedResponseActionTypes = (0, _use_supported_response_action_types.useSupportedResponseActionTypes)();
  const [uiFieldErrors, setUIFieldErrors] = (0, _react.useState)(null);
  const fields = form.getFields();
  const errors = form.getErrors();
  const formContent = (0, _react.useMemo)(() => {
    if (!(supportedResponseActionTypes !== null && supportedResponseActionTypes !== void 0 && supportedResponseActionTypes.length)) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_response_actions_wrapper.ResponseActionsWrapper, {
      items: items,
      removeItem: removeItem,
      supportedResponseActionTypes: supportedResponseActionTypes,
      addItem: addItem,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 43,
        columnNumber: 7
      }
    });
  }, [addItem, items, removeItem, supportedResponseActionTypes]);
  (0, _react.useEffect)(() => {
    setUIFieldErrors(() => {
      const fieldErrors = (0, _lodash.reduce)((0, _lodash.map)(items, 'path'), (acc, path) => {
        (0, _lodash.map)(fields, (_, name) => {
          const paramsPath = `${path}.params`;
          if (name.includes(paramsPath)) {
            var _fields$name, _fields$name$errors;
            if ((_fields$name = fields[name]) !== null && _fields$name !== void 0 && (_fields$name$errors = _fields$name.errors) !== null && _fields$name$errors !== void 0 && _fields$name$errors.length) {
              const responseActionType = (0, _constants.getActionDetails)(fields[`${path}.actionTypeId`].value).name;
              acc.push({
                type: responseActionType,
                errors: (0, _lodash.map)(fields[name].errors, 'message')
              });
            }
            return acc;
          }
          return acc;
        });
        return acc;
      }, []);
      return (0, _lodash.reduce)(fieldErrors, (acc, error) => {
        acc.push(`**${error.type}:**\n`);
        error.errors.forEach(err => {
          acc.push(`- ${err}\n`);
        });
        return acc;
      }, []).join('\n');
    });
  }, [fields, errors, items]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl",
    "data-test-subj": 'response-actions-form',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_response_actions_header.ResponseActionsHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 7
    }
  }), uiFieldErrors !== null && uiFieldErrors !== void 0 && uiFieldErrors.length ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "response-actions-error",
    title: _translations.FORM_ERRORS_TITLE,
    color: "danger",
    iconType: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_reactMarkdown.default, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 15
    }
  }, uiFieldErrors))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 11
    }
  })) : null, formContent);
};
exports.ResponseActionsForm = ResponseActionsForm;