"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TableHeaderTooltipCell = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management_ui/components/rules_table/table_header_tooltip_cell.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * Table header cell component that includes icon(question mark) tooltip with additional details about column
 * Icon tooltip will never be truncated and always be visible for user interaction
 * @param title string - column header title
 * @param tooltipContent string - text content of tooltip
 * @param customTooltip React.ReactNode - any custom tooltip
 */
const TableHeaderTooltipCellComponent = ({
  title,
  tooltipContent,
  customTooltip
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  gutterSize: "none",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 26,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  css: {
    width: 'calc(100% - 20px)'
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 27,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement("span", {
  className: "eui-textTruncate",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 28,
    columnNumber: 7
  }
}, title)), customTooltip !== null && customTooltip !== void 0 ? customTooltip : /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
  content: tooltipContent,
  type: "question",
  color: "subdued",
  anchorProps: {
    css: {
      marginLeft: 4
    },
    'data-test-subj': 'tableHeaderIcon'
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 31,
    columnNumber: 7
  }
}));
const TableHeaderTooltipCell = exports.TableHeaderTooltipCell = /*#__PURE__*/_react.default.memo(TableHeaderTooltipCellComponent);
TableHeaderTooltipCell.displayName = 'TableHeaderTooltipCell';