"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleUpgrade = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _prebuilt_rule_upgrade = require("../../../../model/prebuilt_rule_upgrade");
var _rule_upgrade_info_bar = require("./rule_upgrade_info_bar");
var _rule_upgrade_callout = require("./rule_upgrade_callout");
var _field_upgrade = require("./field_upgrade");
var _field_upgrade_context = require("./field_upgrade_context");
var _missing_base_version_callout = require("./missing_base_version_callout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management/components/rule_details/three_way_diff/rule_upgrade/rule_upgrade.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RuleUpgrade = exports.RuleUpgrade = /*#__PURE__*/(0, _react.memo)(function RuleUpgrade({
  ruleUpgradeState,
  setRuleFieldResolvedValue
}) {
  const totalNumOfFields = calcTotalNumOfFields(ruleUpgradeState);
  const numOfFieldsWithUpdates = calcNumOfFieldsWithUpdates(ruleUpgradeState);
  const numOfSolvableConflicts = calcNumOfSolvableConflicts(ruleUpgradeState);
  const numOfNonSolvableConflicts = calcNumOfNonSolvableConflicts(ruleUpgradeState);
  const fieldNames = extractSortedFieldNames(ruleUpgradeState.fieldsUpgradeState);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_rule_upgrade_info_bar.RuleUpgradeInfoBar, {
    totalNumOfFields: totalNumOfFields,
    numOfFieldsWithUpdates: numOfFieldsWithUpdates,
    numOfConflicts: numOfSolvableConflicts + numOfNonSolvableConflicts,
    currentVersionNumber: ruleUpgradeState.current_rule.version,
    targetVersionNumber: ruleUpgradeState.target_rule.version,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 7
    }
  }), !ruleUpgradeState.has_base_version && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_missing_base_version_callout.RuleHasMissingBaseVersionCallout, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_rule_upgrade_callout.RuleUpgradeCallout, {
    numOfSolvableConflicts: numOfSolvableConflicts,
    numOfNonSolvableConflicts: numOfNonSolvableConflicts,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 7
    }
  }), fieldNames.map(fieldName => /*#__PURE__*/_react.default.createElement(_field_upgrade_context.FieldUpgradeContextProvider, {
    key: fieldName,
    ruleUpgradeState: ruleUpgradeState,
    fieldName: fieldName,
    setRuleFieldResolvedValue: setRuleFieldResolvedValue,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_field_upgrade.FieldUpgrade, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 11
    }
  }))));
});
function calcTotalNumOfFields(ruleUpgradeState) {
  return Object.keys(ruleUpgradeState.fieldsUpgradeState).length;
}
function calcNumOfFieldsWithUpdates(ruleUpgradeState) {
  return Object.values(ruleUpgradeState.fieldsUpgradeState).filter(({
    state
  }) => state !== _prebuilt_rule_upgrade.FieldUpgradeStateEnum.NoUpdate).length;
}
function calcNumOfSolvableConflicts(ruleUpgradeState) {
  return Object.values(ruleUpgradeState.fieldsUpgradeState).filter(({
    state
  }) => state === _prebuilt_rule_upgrade.FieldUpgradeStateEnum.SolvableConflict).length;
}
function calcNumOfNonSolvableConflicts(ruleUpgradeState) {
  return Object.values(ruleUpgradeState.fieldsUpgradeState).filter(({
    state
  }) => state === _prebuilt_rule_upgrade.FieldUpgradeStateEnum.NonSolvableConflict).length;
}

/**
 * Defines fields sorting order by state.
 * Lower number corresponds to higher priority.
 */
const FIELDS_STATE_ORDER_MAP = {
  [_prebuilt_rule_upgrade.FieldUpgradeStateEnum.NonSolvableConflict]: 0,
  [_prebuilt_rule_upgrade.FieldUpgradeStateEnum.SolvableConflict]: 1,
  [_prebuilt_rule_upgrade.FieldUpgradeStateEnum.SameUpdate]: 2,
  [_prebuilt_rule_upgrade.FieldUpgradeStateEnum.NoConflict]: 3,
  [_prebuilt_rule_upgrade.FieldUpgradeStateEnum.Accepted]: 4,
  [_prebuilt_rule_upgrade.FieldUpgradeStateEnum.NoUpdate]: 5
};
function extractSortedFieldNames(fieldsUpgradeState) {
  const fieldNames = Object.keys(fieldsUpgradeState);
  fieldNames.sort((a, b) => FIELDS_STATE_ORDER_MAP[fieldsUpgradeState[a].state] - FIELDS_STATE_ORDER_MAP[fieldsUpgradeState[b].state]);
  return fieldNames;
}