"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePerformSpecificRulesInstallMutation = exports.PERFORM_SPECIFIC_RULES_INSTALLATION_KEY = void 0;
var _reactQuery = require("@tanstack/react-query");
var _urls = require("../../../../../../common/api/detection_engine/prebuilt_rules/urls");
var _api = require("../../api");
var _use_bulk_action_mutation = require("../use_bulk_action_mutation");
var _use_fetch_coverage_overview_query = require("../use_fetch_coverage_overview_query");
var _use_fetch_rule_management_filters_query = require("../use_fetch_rule_management_filters_query");
var _use_fetch_rules_snooze_settings_query = require("../use_fetch_rules_snooze_settings_query");
var _use_find_rules_query = require("../use_find_rules_query");
var _retry_on_rate_limited_error = require("./retry_on_rate_limited_error");
var _use_fetch_prebuilt_rules_install_review_query = require("./use_fetch_prebuilt_rules_install_review_query");
var _use_fetch_prebuilt_rules_status_query = require("./use_fetch_prebuilt_rules_status_query");
var _capped_exponential_backoff = require("./capped_exponential_backoff");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PERFORM_SPECIFIC_RULES_INSTALLATION_KEY = exports.PERFORM_SPECIFIC_RULES_INSTALLATION_KEY = ['POST', 'SPECIFIC_RULES', _urls.PERFORM_RULE_INSTALLATION_URL];
const usePerformSpecificRulesInstallMutation = options => {
  const invalidateFindRulesQuery = (0, _use_find_rules_query.useInvalidateFindRulesQuery)();
  const invalidateFetchRulesSnoozeSettings = (0, _use_fetch_rules_snooze_settings_query.useInvalidateFetchRulesSnoozeSettingsQuery)();
  const invalidatePrePackagedRulesStatus = (0, _use_fetch_prebuilt_rules_status_query.useInvalidateFetchPrebuiltRulesStatusQuery)();
  const invalidateFetchRuleManagementFilters = (0, _use_fetch_rule_management_filters_query.useInvalidateFetchRuleManagementFiltersQuery)();
  const invalidateFetchPrebuiltRulesInstallReview = (0, _use_fetch_prebuilt_rules_install_review_query.useInvalidateFetchPrebuiltRulesInstallReviewQuery)();
  const invalidateRuleStatus = (0, _use_fetch_prebuilt_rules_status_query.useInvalidateFetchPrebuiltRulesStatusQuery)();
  const invalidateFetchCoverageOverviewQuery = (0, _use_fetch_coverage_overview_query.useInvalidateFetchCoverageOverviewQuery)();
  const {
    mutateAsync
  } = (0, _use_bulk_action_mutation.useBulkActionMutation)();
  return (0, _reactQuery.useMutation)(rulesToInstall => (0, _api.performInstallSpecificRules)(rulesToInstall.rules), {
    ...options,
    mutationKey: PERFORM_SPECIFIC_RULES_INSTALLATION_KEY,
    onSettled: (...args) => {
      invalidatePrePackagedRulesStatus();
      invalidateFindRulesQuery();
      invalidateFetchRulesSnoozeSettings();
      invalidateFetchRuleManagementFilters();
      invalidateFetchPrebuiltRulesInstallReview();
      invalidateRuleStatus();
      invalidateFetchCoverageOverviewQuery();
      const [response,, {
        enable
      }] = args;
      if (response && enable) {
        const ruleIdsToEnable = response.results.created.map(rule => rule.id);
        const bulkAction = {
          type: 'enable',
          ids: ruleIdsToEnable
        };
        mutateAsync({
          bulkAction
        });
      }
      if (options !== null && options !== void 0 && options.onSettled) {
        options.onSettled(...args);
      }
    },
    retry: _retry_on_rate_limited_error.retryOnRateLimitedError,
    retryDelay: _capped_exponential_backoff.cappedExponentialBackoff
  });
};
exports.usePerformSpecificRulesInstallMutation = usePerformSpecificRulesInstallMutation;