"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MIN_RISK_SCORE = exports.MAX_RISK_SCORE = void 0;
exports.defaultRiskScoreValidator = defaultRiskScoreValidator;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MIN_RISK_SCORE = exports.MIN_RISK_SCORE = 0;
const MAX_RISK_SCORE = exports.MAX_RISK_SCORE = 100;
function defaultRiskScoreValidator(defaultRiskScore, path) {
  return isDefaultRiskScoreWithinRange(defaultRiskScore) ? undefined : {
    path,
    message: _i18n.i18n.translate('xpack.securitySolution.ruleManagement.ruleCreation.validation.defaultRiskScoreOutOfRangeValidationError', {
      values: {
        min: MIN_RISK_SCORE,
        max: MAX_RISK_SCORE
      },
      defaultMessage: 'Risk score must be between {min} and {max}.'
    })
  };
}
function isDefaultRiskScoreWithinRange(value) {
  return typeof value === 'number' && value >= MIN_RISK_SCORE && value <= MAX_RISK_SCORE;
}