"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEsqlFieldOptions = exports.esqlToOptions = void 0;
var _react = require("react");
var _esql_query_columns = require("../../../rule_creation/logic/esql_query_columns");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const esqlToOptions = (columns, fieldType) => {
  const options = columns.reduce((acc, {
    id,
    meta
  }) => {
    // if fieldType absent, we do not filter columns by type
    if (!fieldType || fieldType === meta.type) {
      acc.push({
        label: id
      });
    }
    return acc;
  }, []);
  return options;
};
exports.esqlToOptions = esqlToOptions;
/**
 * fetches ES|QL fields and convert them to Combobox options
 */
const useEsqlFieldOptions = (esqlQuery, fieldType) => {
  const {
    columns,
    isLoading
  } = (0, _esql_query_columns.useEsqlQueryColumns)(esqlQuery !== null && esqlQuery !== void 0 ? esqlQuery : '');
  const options = (0, _react.useMemo)(() => {
    return esqlToOptions(columns, fieldType);
  }, [columns, fieldType]);
  return {
    options,
    isLoading
  };
};
exports.useEsqlFieldOptions = useEsqlFieldOptions;