"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sharedDataViewManagerSlice = exports.initialSharedState = exports.initialScopeState = exports.createDataViewSelectionSlice = void 0;
var _toolkit = require("@reduxjs/toolkit");
var _constants = require("../constants");
var _actions = require("./actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialScopeState = exports.initialScopeState = {
  dataViewId: null,
  status: 'pristine'
};
const initialSharedState = exports.initialSharedState = {
  dataViews: [],
  adhocDataViews: [],
  status: 'pristine',
  signalIndex: null,
  defaultDataViewId: null,
  alertDataViewId: null
};
const sharedDataViewManagerSlice = exports.sharedDataViewManagerSlice = (0, _toolkit.createSlice)({
  name: `${_constants.SLICE_PREFIX}/shared`,
  initialState: initialSharedState,
  reducers: {
    setDataViews: (state, action) => {
      state.dataViews = action.payload;
      state.status = 'ready';
    },
    setSignalIndex: (state, action) => {
      state.signalIndex = action.payload;
    },
    setDataViewId: (state, action) => {
      state.defaultDataViewId = action.payload.defaultDataViewId;
      state.alertDataViewId = action.payload.alertDataViewId;
    },
    addDataView: (state, action) => {
      const dataViewSpec = action.payload.toSpec();
      if (action.payload.isPersisted()) {
        if (state.dataViews.find(dv => dv.id === dataViewSpec.id)) {
          return;
        }
        state.dataViews.push(dataViewSpec);
      } else {
        if (
        // NOTE: user is allowed to duplicate a managed data view and
        // we want both to show up in the list
        state.adhocDataViews.find(dv => dv.title === dataViewSpec.title && dv.managed === dataViewSpec.managed)) {
          return;
        }
        state.adhocDataViews.push(dataViewSpec);
      }
    },
    init: (state, _) => {
      state.status = 'loading';
    },
    error: state => {
      state.status = 'error';
    }
  }
});
const createDataViewSelectionSlice = scopeName => (0, _toolkit.createSlice)({
  name: `${_constants.SLICE_PREFIX}/${scopeName}`,
  initialState: initialScopeState,
  reducers: {
    setSelectedDataView: (state, action) => {
      var _action$payload;
      state.dataViewId = (_action$payload = action.payload) !== null && _action$payload !== void 0 ? _action$payload : null;
      state.status = 'ready';
    },
    dataViewSelectionError: (state, _) => {
      state.status = 'error';
    }
  },
  extraReducers(builder) {
    builder.addCase(_actions.selectDataViewAsync, (state, action) => {
      if (!action.payload.scope.includes(scopeName)) {
        return state;
      }
      state.status = 'loading';
    });
  }
});
exports.createDataViewSelectionSlice = createDataViewSelectionSlice;