"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBrowserFields = void 0;
var _react = require("react");
var _constants = require("../constants");
var _use_data_view = require("./use_data_view");
var _build_browser_fields = require("../utils/build_browser_fields");
var _use_experimental_features = require("../../common/hooks/use_experimental_features");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const emptyFields = {};
const useBrowserFields = (scope = _constants.DataViewManagerScopeName.default, oldDataView) => {
  const {
    dataView
  } = (0, _use_data_view.useDataView)(scope);
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const activeDataView = newDataViewPickerEnabled ? dataView : oldDataView;
  return (0, _react.useMemo)(() => {
    if (!(activeDataView !== null && activeDataView !== void 0 && activeDataView.id)) {
      return emptyFields;
    }
    const browserFields = (0, _build_browser_fields.buildBrowserFields)(activeDataView === null || activeDataView === void 0 ? void 0 : activeDataView.fields);
    return browserFields;
  }, [activeDataView]);
};
exports.useBrowserFields = useBrowserFields;