"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBoolState = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useBoolState = (initial = false) => {
  const [state, setState] = (0, _react.useState)(initial);
  const setTrue = (0, _react.useCallback)(() => {
    setState(true);
  }, []);
  const setFalse = (0, _react.useCallback)(() => {
    setState(false);
  }, []);
  const toggle = (0, _react.useCallback)(() => {
    setState(val => !val);
  }, []);
  return [state, setTrue, setFalse, toggle];
};
exports.useBoolState = useBoolState;