"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useHostRelatedUsers = void 0;
var _react = require("react");
var _related_entities = require("../../../../../common/search_strategy/security_solution/related_entities");
var _use_search_strategy = require("../../use_search_strategy");
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useHostRelatedUsers = ({
  hostName,
  indexNames,
  from,
  skip = false
}) => {
  const {
    loading,
    result: response,
    search,
    refetch,
    inspect
  } = (0, _use_search_strategy.useSearchStrategy)({
    factoryQueryType: _related_entities.RelatedEntitiesQueries.relatedUsers,
    initialResult: {
      totalCount: 0,
      relatedUsers: []
    },
    errorMessage: _translations.FAIL_RELATED_USERS,
    abort: skip
  });
  const hostRelatedUsersResponse = (0, _react.useMemo)(() => ({
    inspect,
    totalCount: response.totalCount,
    relatedUsers: response.relatedUsers,
    refetch,
    loading
  }), [inspect, refetch, response.totalCount, response.relatedUsers, loading]);
  const hostRelatedUsersRequest = (0, _react.useMemo)(() => ({
    defaultIndex: indexNames,
    factoryQueryType: _related_entities.RelatedEntitiesQueries.relatedUsers,
    hostName,
    from
  }), [indexNames, from, hostName]);
  (0, _react.useEffect)(() => {
    if (!skip) {
      search(hostRelatedUsersRequest);
    }
  }, [hostRelatedUsersRequest, search, skip]);
  return hostRelatedUsersResponse;
};
exports.useHostRelatedUsers = useHostRelatedUsers;