"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getExternalAlertLensAttributes = void 0;
var _uuid = require("uuid");
var _translations = require("../../translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const layerId = `layer-id-${(0, _uuid.v4)()}`;
const columnTimestamp = `column-timestamp-id-${(0, _uuid.v4)()}`;
const columnCount = `column-count-id-${(0, _uuid.v4)()}`;
const columnTopValue = `column-top-value-id-${(0, _uuid.v4)()}`;
const getExternalAlertLensAttributes = ({
  stackByField = 'event.module'
}) => {
  return {
    title: 'External alerts',
    description: '',
    visualizationType: 'lnsXY',
    state: {
      visualization: {
        title: 'Empty XY chart',
        legend: {
          isVisible: true,
          position: 'right',
          legendSize: 'xlarge',
          legendStats: ['currentAndLastValue']
        },
        valueLabels: 'hide',
        preferredSeriesType: 'bar_stacked',
        layers: [{
          layerId,
          accessors: [columnCount],
          position: 'top',
          seriesType: 'bar_stacked',
          showGridlines: false,
          layerType: 'data',
          xAccessor: columnTimestamp,
          splitAccessor: columnTopValue
        }],
        yRightExtent: {
          mode: 'full'
        },
        yLeftExtent: {
          mode: 'full'
        },
        axisTitlesVisibilitySettings: {
          x: false,
          yLeft: false,
          yRight: true
        }
      },
      query: {
        query: '',
        language: 'kuery'
      },
      filters: [{
        meta: {
          index: 'a04472fc-94a3-4b8d-ae05-9d30ea8fbd6a',
          alias: null,
          negate: false,
          disabled: false,
          type: 'phrase',
          key: 'event.kind',
          params: {
            query: 'alert'
          }
        },
        query: {
          match_phrase: {
            'event.kind': 'alert'
          }
        },
        $state: {
          store: 'appState'
        }
      }],
      datasourceStates: {
        formBased: {
          layers: {
            [layerId]: {
              columns: {
                [columnTimestamp]: {
                  label: '@timestamp',
                  dataType: 'date',
                  operationType: 'date_histogram',
                  sourceField: '@timestamp',
                  isBucketed: true,
                  scale: 'interval',
                  params: {
                    interval: 'auto',
                    includeEmptyRows: true
                  }
                },
                [columnCount]: {
                  label: _translations.COUNT,
                  dataType: 'number',
                  operationType: 'count',
                  isBucketed: false,
                  scale: 'ratio',
                  sourceField: '___records___',
                  params: {
                    emptyAsNull: true
                  }
                },
                [columnTopValue]: {
                  label: (0, _translations.TOP_VALUE)(`${stackByField}`),
                  dataType: 'string',
                  operationType: 'terms',
                  scale: 'ordinal',
                  sourceField: `${stackByField}`,
                  isBucketed: true,
                  params: {
                    size: 10,
                    orderBy: {
                      type: 'column',
                      columnId: columnCount
                    },
                    orderDirection: 'desc',
                    otherBucket: true,
                    missingBucket: false,
                    parentFormat: {
                      id: 'terms'
                    }
                  }
                }
              },
              columnOrder: [columnTopValue, columnTimestamp, columnCount],
              incompleteColumns: {}
            }
          }
        }
      }
    },
    references: [{
      type: 'index-pattern',
      id: '{dataViewId}',
      name: 'indexpattern-datasource-current-indexpattern'
    }, {
      type: 'index-pattern',
      id: '{dataViewId}',
      name: `indexpattern-datasource-layer-${layerId}`
    }, {
      type: 'index-pattern',
      name: '723c4653-681b-4105-956e-abef287bf025',
      id: '{dataViewId}'
    }, {
      type: 'index-pattern',
      name: 'a04472fc-94a3-4b8d-ae05-9d30ea8fbd6a',
      id: '{dataViewId}'
    }]
  };
};
exports.getExternalAlertLensAttributes = getExternalAlertLensAttributes;