"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SeverityBadge = void 0;
var _react = _interopRequireDefault(require("react"));
var _fp = require("lodash/fp");
var _eui = require("@elastic/eui");
var _health_truncate_text = require("../health_truncate_text");
var _risk_color_palette = require("../../utils/risk_color_palette");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/severity_badge/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const SeverityBadgeComponent = ({
  value,
  'data-test-subj': dataTestSubj = 'severity'
}) => {
  var _severityToColorMap$v;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const displayValue = (0, _fp.upperFirst)(value);
  const severityToColorMap = (0, _risk_color_palette.useRiskSeverityColors)();
  const color = (_severityToColorMap$v = severityToColorMap[value]) !== null && _severityToColorMap$v !== void 0 ? _severityToColorMap$v : euiTheme.colors.textSubdued;
  return /*#__PURE__*/_react.default.createElement(_health_truncate_text.HealthTruncateText, {
    healthColor: color,
    tooltipContent: displayValue,
    dataTestSubj: dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 5
    }
  }, displayValue);
};
const SeverityBadge = exports.SeverityBadge = /*#__PURE__*/_react.default.memo(SeverityBadgeComponent);