"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UNIT = exports.SHOWING = exports.EVENTS = exports.ACTIONS = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SHOWING = exports.SHOWING = _i18n.i18n.translate('xpack.securitySolution.eventsViewer.showingLabel', {
  defaultMessage: 'Showing'
});
const EVENTS = exports.EVENTS = _i18n.i18n.translate('xpack.securitySolution.eventsViewer.eventsLabel', {
  defaultMessage: 'Events'
});
const UNIT = totalCount => _i18n.i18n.translate('xpack.securitySolution.eventsViewer.unit', {
  values: {
    totalCount
  },
  defaultMessage: `{totalCount, plural, =1 {event} other {events}}`
});
exports.UNIT = UNIT;
const ACTIONS = exports.ACTIONS = _i18n.i18n.translate('xpack.securitySolution.eventsViewer.actionsColumnLabel', {
  defaultMessage: 'Actions'
});