"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionableSummary = void 0;
var _eui = require("@elastic/eui");
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _react = _interopRequireWildcard(require("react"));
var _common = require("../../../../../../common");
var _kibana = require("../../../../../common/lib/kibana");
var _attack_discovery_markdown_formatter = require("../../attack_discovery_markdown_formatter");
var _view_in_ai_assistant = require("../view_in_ai_assistant");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/attack_discovery/pages/results/attack_discovery_panel/actionable_summary/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ActionableSummaryComponent = ({
  attackDiscovery,
  replacements,
  showAnonymized = false
}) => {
  const {
    application: {
      capabilities
    }
  } = (0, _kibana.useKibana)().services;
  // TODO We shouldn't have to check capabilities here, this should be done at a much higher level.
  //  https://github.com/elastic/kibana/issues/218731
  //  For EASE we need to hide cell actions and all preview links that could open non-EASE flyouts
  const disabledActions = (0, _react.useMemo)(() => showAnonymized || Boolean(capabilities[_common.SECURITY_FEATURE_ID].configurations), [capabilities, showAnonymized]);
  const entitySummary = (0, _react.useMemo)(() => {
    var _attackDiscovery$enti;
    return showAnonymized ? attackDiscovery.entitySummaryMarkdown : (0, _elasticAssistantCommon.replaceAnonymizedValuesWithOriginalValues)({
      messageContent: (_attackDiscovery$enti = attackDiscovery.entitySummaryMarkdown) !== null && _attackDiscovery$enti !== void 0 ? _attackDiscovery$enti : '',
      replacements: {
        ...replacements
      }
    });
  }, [attackDiscovery.entitySummaryMarkdown, replacements, showAnonymized]);

  // title will be used as a fallback if entitySummaryMarkdown is empty
  const title = (0, _react.useMemo)(() => showAnonymized ? attackDiscovery.title : (0, _elasticAssistantCommon.replaceAnonymizedValuesWithOriginalValues)({
    messageContent: attackDiscovery.title,
    replacements: {
      ...replacements
    }
  }), [attackDiscovery.title, replacements, showAnonymized]);
  const entitySummaryOrTitle = entitySummary != null && entitySummary.length > 0 ? entitySummary : title;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    "data-test-subj": "actionableSummary",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none",
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "entitySummaryMarkdown",
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_attack_discovery_markdown_formatter.AttackDiscoveryMarkdownFormatter, {
    disableActions: disabledActions,
    markdown: entitySummaryOrTitle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_view_in_ai_assistant.ViewInAiAssistant, {
    compact: true,
    attackDiscovery: attackDiscovery,
    replacements: replacements,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 11
    }
  }))));
};
ActionableSummaryComponent.displayName = 'ActionableSummary';
const ActionableSummary = exports.ActionableSummary = /*#__PURE__*/_react.default.memo(ActionableSummaryComponent);