"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createCopyToClipboardLensAction = exports.ACTION_ID = void 0;
var _public = require("@kbn/ui-actions-plugin/public");
var _copyToClipboard = _interopRequireDefault(require("copy-to-clipboard"));
var _presentationPublishing = require("@kbn/presentation-publishing");
var _public2 = require("@kbn/lens-plugin/public");
var _is_in_security_app = require("../../../../common/hooks/is_in_security_app");
var _kibana = require("../../../../common/lib/kibana");
var _utils = require("../../utils");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ACTION_ID = exports.ACTION_ID = 'embeddable_copyToClipboard';
function isDataColumnsValid(data) {
  return !!data && data.length > 0 && data.every(({
    columnMeta
  }) => columnMeta && (0, _utils.fieldHasCellActions)(columnMeta.field));
}
const createCopyToClipboardLensAction = ({
  order
}) => {
  const {
    application: applicationService
  } = _kibana.KibanaServices.get();
  let currentAppId;
  applicationService.currentAppId$.subscribe(appId => {
    currentAppId = appId;
  });
  return (0, _public.createAction)({
    id: ACTION_ID,
    type: ACTION_ID,
    order,
    getIconType: () => _constants.COPY_TO_CLIPBOARD_ICON,
    getDisplayName: () => _constants.COPY_TO_CLIPBOARD,
    isCompatible: async ({
      embeddable,
      data
    }) => !(0, _presentationPublishing.hasBlockingError)(embeddable) && (0, _public2.isLensApi)(embeddable) && isDataColumnsValid(data) && (0, _is_in_security_app.isInSecurityApp)(currentAppId),
    execute: async ({
      data
    }) => {
      const {
        notifications: {
          toasts: toastsService
        }
      } = _kibana.KibanaServices.get();
      const text = data.map(({
        columnMeta,
        value
      }) => {
        var _columnMeta$sourcePar;
        if ((0, _utils.isCountField)(columnMeta === null || columnMeta === void 0 ? void 0 : columnMeta.type, columnMeta === null || columnMeta === void 0 ? void 0 : (_columnMeta$sourcePar = columnMeta.sourceParams) === null || _columnMeta$sourcePar === void 0 ? void 0 : _columnMeta$sourcePar.type)) {
          return `${columnMeta === null || columnMeta === void 0 ? void 0 : columnMeta.field}: *`;
        }
        return `${columnMeta === null || columnMeta === void 0 ? void 0 : columnMeta.field}${value != null ? `: "${value}"` : ''}`;
      }).join(' | ');
      const isSuccess = (0, _copyToClipboard.default)(text, {
        debug: true
      });
      if (isSuccess) {
        toastsService.addSuccess({
          title: _constants.COPY_TO_CLIPBOARD_SUCCESS,
          toastLifeTimeMs: 800
        });
      }
    }
  });
};
exports.createCopyToClipboardLensAction = createCopyToClipboardLensAction;