"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPrivmonMonitoringSourceByIdUrl = exports.PRIVMON_USERS_CSV_SIZE_TOLERANCE_BYTES = exports.PRIVMON_USERS_CSV_MAX_SIZE_BYTES_WITH_TOLERANCE = exports.PRIVMON_USERS_CSV_MAX_SIZE_BYTES = exports.PRIVMON_PRIVILEGE_CHECK_API = exports.PRIVMON_INDICES_URL = exports.PRIVMON_HEALTH_URL = exports.PRIVMON_BASE_INDEX_NAME = exports.MONITORING_USERS_URL = exports.MONITORING_USERS_LIST_URL = exports.MONITORING_USERS_CSV_UPLOAD_URL = exports.MONITORING_ENTITY_SOURCE_URL = exports.MONITORING_ENTITY_LIST_SOURCES_URL = exports.MONITORING_ENGINE_SCHEDULE_NOW_URL = exports.MONITORING_ENGINE_INIT_URL = exports.MONITORING_ENGINE_DISABLE_URL = exports.MONITORING_ENGINE_DELETE_URL = exports.ML_ANOMALIES_INDEX = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Static index names: may be more obvious and easier to manage.
const PRIVMON_BASE_INDEX_NAME = exports.PRIVMON_BASE_INDEX_NAME = '.entity_analytics.monitoring';
const ML_ANOMALIES_INDEX = exports.ML_ANOMALIES_INDEX = '.ml-anomalies-shared';

// CSV Upload
const PRIVMON_USERS_CSV_MAX_SIZE_BYTES = exports.PRIVMON_USERS_CSV_MAX_SIZE_BYTES = 1024 * 1024; // 1MB
const PRIVMON_USERS_CSV_SIZE_TOLERANCE_BYTES = exports.PRIVMON_USERS_CSV_SIZE_TOLERANCE_BYTES = 1024 * 50; // ~= 50kb
const PRIVMON_USERS_CSV_MAX_SIZE_BYTES_WITH_TOLERANCE = exports.PRIVMON_USERS_CSV_MAX_SIZE_BYTES_WITH_TOLERANCE = PRIVMON_USERS_CSV_MAX_SIZE_BYTES + PRIVMON_USERS_CSV_SIZE_TOLERANCE_BYTES;
const MONITORING_URL = `/api/entity_analytics/monitoring`;

// Monitoring users URLs
const MONITORING_USERS_URL = exports.MONITORING_USERS_URL = `${MONITORING_URL}/users`;
const MONITORING_USERS_CSV_UPLOAD_URL = exports.MONITORING_USERS_CSV_UPLOAD_URL = `${MONITORING_USERS_URL}/_csv`;
const MONITORING_USERS_LIST_URL = exports.MONITORING_USERS_LIST_URL = `${MONITORING_USERS_URL}/list`;

// Monitoring entity source URLs
const MONITORING_ENTITY_SOURCE_URL = exports.MONITORING_ENTITY_SOURCE_URL = `${MONITORING_URL}/entity_source`;
const MONITORING_ENTITY_LIST_SOURCES_URL = exports.MONITORING_ENTITY_LIST_SOURCES_URL = `${MONITORING_ENTITY_SOURCE_URL}/list`;
const getPrivmonMonitoringSourceByIdUrl = id => `${MONITORING_ENTITY_SOURCE_URL}/${id}`;

// Privilege Monitoring URLs
exports.getPrivmonMonitoringSourceByIdUrl = getPrivmonMonitoringSourceByIdUrl;
const PRIVMON_URL = `${MONITORING_URL}/privileges`;
const PRIVMON_PRIVILEGE_CHECK_API = exports.PRIVMON_PRIVILEGE_CHECK_API = `${PRIVMON_URL}/privileges`;
const PRIVMON_INDICES_URL = exports.PRIVMON_INDICES_URL = `${PRIVMON_URL}/indices`;
const PRIVMON_HEALTH_URL = exports.PRIVMON_HEALTH_URL = `${PRIVMON_URL}/health`;

// Monitoring Engine URLs
const MONITORING_ENGINE_URL = `${MONITORING_URL}/engine`;
const MONITORING_ENGINE_INIT_URL = exports.MONITORING_ENGINE_INIT_URL = `${MONITORING_ENGINE_URL}/init`;
const MONITORING_ENGINE_SCHEDULE_NOW_URL = exports.MONITORING_ENGINE_SCHEDULE_NOW_URL = `${MONITORING_ENGINE_URL}/schedule_now`;
const MONITORING_ENGINE_DELETE_URL = exports.MONITORING_ENGINE_DELETE_URL = `${MONITORING_ENGINE_URL}/delete`;
const MONITORING_ENGINE_DISABLE_URL = exports.MONITORING_ENGINE_DISABLE_URL = `${MONITORING_ENGINE_URL}/disable`;