"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpdatedMonitoringEntitySource = exports.UpdateEntitySourceResponse = exports.UpdateEntitySourceRequestParams = exports.UpdateEntitySourceRequestBody = exports.MonitoringEntitySourceProperties = exports.MonitoringEntitySourceNoId = exports.MonitoringEntitySource = exports.Matcher = exports.ListEntitySourcesResponse = exports.ListEntitySourcesRequestQuery = exports.Integrations = exports.GetEntitySourceResponse = exports.GetEntitySourceRequestParams = exports.DeleteEntitySourceRequestParams = exports.CreateMonitoringEntitySource = exports.CreateEntitySourceResponse = exports.CreateEntitySourceRequestBody = void 0;
var _zod = require("@kbn/zod");
var _zodHelpers = require("@kbn/zod-helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Monitoring Entity Source Schema
 *   version: 2023-10-31
 */

const Integrations = exports.Integrations = _zod.z.object({
  /**
   * Index to read latest sync markers from
   */
  syncMarkerIndex: _zod.z.string().optional(),
  /**
   * integrations latest full sync and update syncData
   */
  syncData: _zod.z.object({
    /**
     * Timestamp of the last full sync from integrations
     */
    lastFullSync: _zod.z.string().datetime().optional(),
    /**
     * Timestamp of the last update processed from integrations
     */
    lastUpdateProcessed: _zod.z.string().datetime().optional()
  }).optional()
});
const CreateMonitoringEntitySource = exports.CreateMonitoringEntitySource = _zod.z.object({
  type: _zod.z.string(),
  name: _zod.z.string(),
  managed: _zod.z.boolean().optional(),
  indexPattern: _zod.z.string().optional(),
  enabled: _zod.z.boolean().optional(),
  error: _zod.z.string().optional(),
  integrationName: _zod.z.string().optional(),
  matchers: _zod.z.array(_zod.z.object({
    fields: _zod.z.array(_zod.z.string()),
    values: _zod.z.array(_zod.z.string())
  })).optional(),
  filter: _zod.z.object({
    kuery: _zod.z.union([_zod.z.string(), _zod.z.object({})]).optional()
  }).optional(),
  integrations: Integrations.optional()
});
const UpdatedMonitoringEntitySource = exports.UpdatedMonitoringEntitySource = _zod.z.object({
  type: _zod.z.string().optional(),
  name: _zod.z.string().optional(),
  managed: _zod.z.boolean().optional(),
  indexPattern: _zod.z.string().optional(),
  enabled: _zod.z.boolean().optional(),
  error: _zod.z.string().optional(),
  integrationName: _zod.z.string().optional(),
  matchers: _zod.z.array(_zod.z.object({
    fields: _zod.z.array(_zod.z.string()),
    values: _zod.z.array(_zod.z.string())
  })).optional(),
  filter: _zod.z.object({
    kuery: _zod.z.union([_zod.z.string(), _zod.z.object({})]).optional()
  }).optional(),
  integrations: Integrations.optional()
});
const Matcher = exports.Matcher = _zod.z.object({
  fields: _zod.z.array(_zod.z.string()),
  values: _zod.z.array(_zod.z.string())
});
const MonitoringEntitySourceProperties = exports.MonitoringEntitySourceProperties = _zod.z.object({
  name: _zod.z.string().optional(),
  type: _zod.z.string().optional(),
  managed: _zod.z.boolean().optional(),
  indexPattern: _zod.z.string().optional(),
  integrationName: _zod.z.string().optional(),
  enabled: _zod.z.boolean().optional(),
  matchers: _zod.z.array(Matcher).optional(),
  filter: _zod.z.object({
    kuery: _zod.z.union([_zod.z.string(), _zod.z.object({})]).optional()
  }).optional(),
  integrations: Integrations.optional()
});
const MonitoringEntitySourceNoId = exports.MonitoringEntitySourceNoId = MonitoringEntitySourceProperties.merge(_zod.z.object({}));
const MonitoringEntitySource = exports.MonitoringEntitySource = MonitoringEntitySourceProperties.merge(_zod.z.object({
  id: _zod.z.string()
}));
const CreateEntitySourceRequestBody = exports.CreateEntitySourceRequestBody = CreateMonitoringEntitySource;
const CreateEntitySourceResponse = exports.CreateEntitySourceResponse = MonitoringEntitySource;
const DeleteEntitySourceRequestParams = exports.DeleteEntitySourceRequestParams = _zod.z.object({
  id: _zod.z.string()
});
const GetEntitySourceRequestParams = exports.GetEntitySourceRequestParams = _zod.z.object({
  id: _zod.z.string()
});
const GetEntitySourceResponse = exports.GetEntitySourceResponse = MonitoringEntitySource;
const ListEntitySourcesRequestQuery = exports.ListEntitySourcesRequestQuery = _zod.z.object({
  type: _zod.z.string().optional(),
  managed: _zodHelpers.BooleanFromString.optional(),
  name: _zod.z.string().optional()
});
const ListEntitySourcesResponse = exports.ListEntitySourcesResponse = _zod.z.array(MonitoringEntitySource);
const UpdateEntitySourceRequestParams = exports.UpdateEntitySourceRequestParams = _zod.z.object({
  id: _zod.z.string()
});
const UpdateEntitySourceRequestBody = exports.UpdateEntitySourceRequestBody = MonitoringEntitySourceNoId;
const UpdateEntitySourceResponse = exports.UpdateEntitySourceResponse = MonitoringEntitySource;