"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isInlineRoleTemplate = isInlineRoleTemplate;
exports.isInvalidRoleTemplate = isInvalidRoleTemplate;
exports.isStoredRoleTemplate = isStoredRoleTemplate;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function isStoredRoleTemplate(roleMappingTemplate) {
  return roleMappingTemplate.template != null && typeof roleMappingTemplate.template === 'object' && Object.hasOwn(roleMappingTemplate.template, 'id') && typeof roleMappingTemplate.template.id === 'string';
}
function isInlineRoleTemplate(roleMappingTemplate) {
  return roleMappingTemplate.template != null && typeof roleMappingTemplate.template === 'object' && Object.hasOwn(roleMappingTemplate.template, 'source') && typeof roleMappingTemplate.template.source === 'string';
}
function isInvalidRoleTemplate(roleMappingTemplate) {
  return !isStoredRoleTemplate(roleMappingTemplate) && !isInlineRoleTemplate(roleMappingTemplate);
}