"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.promptType = exports.promptSavedObjectType = exports.promptSavedObjectMappings = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const promptSavedObjectType = exports.promptSavedObjectType = 'security-ai-prompt';
const promptSavedObjectMappings = exports.promptSavedObjectMappings = {
  dynamic: false,
  properties: {
    description: {
      type: 'text'
    },
    promptId: {
      // represent unique prompt
      type: 'keyword'
    },
    promptGroupId: {
      // represents unique groups of prompts
      type: 'keyword'
    },
    provider: {
      type: 'keyword'
    },
    model: {
      type: 'keyword'
    },
    prompt: {
      properties: {
        // English is default
        default: {
          type: 'text'
        }
        // optionally, add ISO 639 two-letter language code to support more translations
      }
    }
  }
};
const promptType = exports.promptType = {
  name: promptSavedObjectType,
  hidden: false,
  management: {
    importableAndExportable: true,
    visibleInManagement: false // <--hide in management
  },
  namespaceType: 'agnostic',
  mappings: promptSavedObjectMappings
};