"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchQueryRulesQueryRule = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchQueryRulesQueryRule = async (client, rulesetId, ruleId) => {
  const result = await client.queryRules.getRule({
    ruleset_id: rulesetId,
    rule_id: ruleId
  });
  return {
    ...result,
    criteria: !Array.isArray(result.criteria) ? [result.criteria] : result.criteria
  };
};
exports.fetchQueryRulesQueryRule = fetchQueryRulesQueryRule;