"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteInferenceEndpoint = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const deleteInferenceEndpoint = async (client, type, id, scanUsage) => {
  if (scanUsage) {
    return await client.inference.delete({
      inference_id: id,
      task_type: type,
      dry_run: true
    });
  }
  return await client.inference.delete({
    inference_id: id,
    task_type: type,
    force: true
  });
};
exports.deleteInferenceEndpoint = deleteInferenceEndpoint;