"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConsoleSemanticIngestDataExample = exports.ConsoleSearchExample = exports.ConsoleIngestDataExample = exports.ConsoleCreateIndexExamples = void 0;
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConsoleCreateIndexExamples = exports.ConsoleCreateIndexExamples = {
  default: {
    createIndex: ({
      indexName
    }) => `PUT /${indexName !== null && indexName !== void 0 ? indexName : _constants.INDEX_PLACEHOLDER}
{
  "mappings": {
    "properties":{
      "text":{
        "type":"text"
      }
    }
  }
}`
  },
  dense_vector: {
    createIndex: ({
      indexName
    }) => `PUT /${indexName !== null && indexName !== void 0 ? indexName : _constants.INDEX_PLACEHOLDER}
{
  "mappings": {
    "properties":{
      "vector":{
        "type": "dense_vector",
        "dims": 3
      },
      "text":{
        "type":"text"
      }
    }
  }
}`
  },
  semantic: {
    createIndex: ({
      indexName
    }) => `PUT /${indexName !== null && indexName !== void 0 ? indexName : _constants.INDEX_PLACEHOLDER}
{
  "mappings": {
    "properties":{
      "text":{
        "type":"semantic_text"
      }
    }
  }
}`
  }
};
const ConsoleIngestDataExample = exports.ConsoleIngestDataExample = {
  ingestCommand: ({
    indexName,
    sampleDocuments
  }) => {
    let result = 'POST /_bulk?pretty\n';
    sampleDocuments.forEach(document => {
      result += `{ "index": { "_index": "${indexName}" } }
${JSON.stringify(document)}\n`;
    });
    result += '\n';
    return result;
  },
  updateMappingsCommand: ({
    indexName,
    mappingProperties
  }) => `PUT /${indexName}/_mapping
${JSON.stringify({
    properties: mappingProperties
  }, null, 2)}`
};
const ConsoleSemanticIngestDataExample = exports.ConsoleSemanticIngestDataExample = {
  ...ConsoleIngestDataExample,
  ingestCommand: ({
    indexName,
    sampleDocuments
  }) => {
    let result = `# The initial bulk ingestion request could take longer than the default request timeout.
# If this request times out, you should retry the request after allowing time for the machine learning model loading to complete (typically 1-5 minutes).
POST /_bulk?pretty\n`;
    sampleDocuments.forEach(document => {
      result += `{ "index": { "_index": "${indexName}" } }
${JSON.stringify(document)}\n`;
    });
    result += '\n';
    return result;
  }
};
const searchCommand = ({
  indexName,
  queryObject
}) => `POST /${indexName}/_search
${JSON.stringify(queryObject, null, 2)}`;
const ConsoleSearchExample = exports.ConsoleSearchExample = {
  searchCommand
};