"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetApiKeys = void 0;
var _reactQuery = require("@tanstack/react-query");
var _use_kibana = require("../use_kibana");
var _routes = require("../../../common/routes");
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useGetApiKeys = () => {
  const {
    http
  } = (0, _use_kibana.useKibana)().services;
  return (0, _reactQuery.useQuery)({
    queryKey: [_constants.QueryKeys.ApiKey],
    queryFn: () => http.fetch(_routes.GET_API_KEYS_ROUTE)
  });
};
exports.useGetApiKeys = useGetApiKeys;