"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTableActions = void 0;
var _delete = require("./delete");
var _edit = require("./edit");
var _assign = require("./assign");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getTableActions = ({
  startServices,
  capabilities,
  tagClient,
  tagCache,
  assignmentService,
  assignableTypes,
  fetchTags,
  canceled$
}) => {
  const actions = [];
  if (capabilities.edit) {
    actions.push((0, _edit.getEditAction)({
      ...startServices,
      tagClient,
      fetchTags
    }));
  }
  if (capabilities.assign && assignableTypes.length > 0) {
    actions.push((0, _assign.getAssignAction)({
      ...startServices,
      tagCache,
      assignmentService,
      assignableTypes,
      fetchTags,
      canceled$
    }));
  }
  if (capabilities.delete) {
    actions.push((0, _delete.getDeleteAction)({
      ...startServices,
      tagClient,
      fetchTags
    }));
  }
  return actions;
};
exports.getTableActions = getTableActions;