"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _queryString = require("query-string");
var _i18n = require("@kbn/i18n");
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _react2 = require("@emotion/react");
var _object_view = require("./object_view");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/saved_objects_management/public/management_section/saved_objects_edition_page.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SavedObjectsEditionPage = ({
  coreStart,
  setBreadcrumbs,
  history
}) => {
  const {
    type,
    id
  } = (0, _reactRouterDom.useParams)();
  const capabilities = coreStart.application.capabilities;
  const docLinks = coreStart.docLinks.links;
  const {
    search
  } = (0, _reactRouterDom.useLocation)();
  const query = (0, _queryString.parse)(search);
  (0, _react.useEffect)(() => {
    setBreadcrumbs([{
      text: _i18n.i18n.translate('savedObjectsManagement.breadcrumb.index', {
        defaultMessage: 'Saved objects'
      }),
      href: '/'
    }, {
      text: _i18n.i18n.translate('savedObjectsManagement.breadcrumb.inspect', {
        defaultMessage: 'Inspect {savedObjectType}',
        values: {
          savedObjectType: type
        }
      })
    }]);
  }, [setBreadcrumbs, type]);
  return /*#__PURE__*/_react.default.createElement("div", {
    css: styles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
    coreStart: {
      application: coreStart.application
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_object_view.SavedObjectEdition, {
    id: id,
    savedObjectType: type,
    http: coreStart.http,
    overlays: coreStart.overlays,
    notifications: coreStart.notifications,
    capabilities: capabilities,
    notFoundType: query.notFound,
    uiSettings: coreStart.uiSettings,
    history: history,
    docLinks: docLinks,
    settings: coreStart.settings,
    theme: coreStart.theme,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 9
    }
  })));
};
exports.default = SavedObjectsEditionPage;
const styles = (0, _react2.css)({
  height: '100%'
});

// eslint-disable-next-line import/no-default-export
module.exports = exports.default;