"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "createCtx", {
  enumerable: true,
  get: function () {
    return _context.createCtx;
  }
});
exports.postProcessMutations = void 0;
var mutations = _interopRequireWildcard(require("./mutations"));
var _utils = require("./mutations/utils");
var _common = require("../../common");
var _context = require("./context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const postProcessMutations = ({
  ctx,
  schema
}) => {
  walkSchema(ctx, schema);
  return ctx;
};
exports.postProcessMutations = postProcessMutations;
const arrayContainers = ['allOf', 'oneOf', 'anyOf'];
const walkSchema = (ctx, schema) => {
  if ((0, _common.isReferenceObject)(schema)) return;
  if ((0, _utils.isAnyType)(schema)) {
    mutations.processAnyType(schema);
    return;
  }
  mutations.processAllTypes(schema);
  /* At runtime 'type' can be broader than 'NonArraySchemaObjectType', so we set it to 'string' */
  const type = schema.type;
  if (type === 'array') {
    const items = schema.items;
    walkSchema(ctx, items);
  } else if (type === 'object') {
    if (schema.properties) {
      Object.values(schema.properties).forEach(value => {
        walkSchema(ctx, value);
      });
    }
    mutations.processObject(schema);
  } else if (type === 'string') {
    mutations.processString(schema);
  } else if (type === 'record') {
    mutations.processRecord(ctx, schema);
  } else if (type === 'map') {
    mutations.processMap(ctx, schema);
  } else if (type === 'stream') {
    mutations.processStream(schema);
  } else if (schema.type) {
    // Do nothing
  } else {
    for (const arrayContainer of arrayContainers) {
      if (schema[arrayContainer]) {
        schema[arrayContainer].forEach(s => {
          walkSchema(ctx, s);
        });
        mutations.processEnum(schema);
        break;
      }
    }
  }
};