"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExportType = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _common = require("@kbn/spaces-plugin/common");
var _coreHttpServerUtils = require("@kbn/core-http-server-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class ExportType {
  constructor(core, config, logger, context) {
    // ID for exportTypesRegistry.getById()
    // user-facing string
    // for job params
    (0, _defineProperty2.default)(this, "setupDeps", void 0);
    (0, _defineProperty2.default)(this, "startDeps", void 0);
    (0, _defineProperty2.default)(this, "http", void 0);
    this.config = config;
    this.logger = logger;
    this.context = context;
    this.http = core.http;
  }
  setup(setupDeps) {
    this.setupDeps = setupDeps;
  }
  start(startDeps) {
    this.startDeps = startDeps;
  }
  async getSavedObjectsClient(request) {
    const {
      savedObjects
    } = this.startDeps;
    return savedObjects.getScopedClient(request);
  }
  getSpaceId(request, logger = this.logger) {
    var _this$setupDeps$space;
    const spacesService = (_this$setupDeps$space = this.setupDeps.spaces) === null || _this$setupDeps$space === void 0 ? void 0 : _this$setupDeps$space.spacesService;
    if (spacesService) {
      const spaceId = spacesService === null || spacesService === void 0 ? void 0 : spacesService.getSpaceId(request);
      if (spaceId !== _common.DEFAULT_SPACE_ID) {
        logger.info(`Request uses Space ID: ${spaceId}`);
        return spaceId;
      } else {
        logger.debug(`Request uses default Space`);
      }
    }
  }
  getUiSettingsServiceFactory(savedObjectsClient) {
    const {
      uiSettings: uiSettingsService
    } = this.startDeps;
    const scopedUiSettingsService = uiSettingsService.asScopedToClient(savedObjectsClient);
    return scopedUiSettingsService;
  }
  async getUiSettingsClient(request, logger = this.logger) {
    var _this$setupDeps$space2;
    const spacesService = (_this$setupDeps$space2 = this.setupDeps.spaces) === null || _this$setupDeps$space2 === void 0 ? void 0 : _this$setupDeps$space2.spacesService;
    const spaceId = this.getSpaceId(request, logger);
    if (spacesService && spaceId) {
      logger.info(`Creating UI Settings Client for space: ${spaceId}`);
    }
    const savedObjectsClient = await this.getSavedObjectsClient(request);
    return this.getUiSettingsServiceFactory(savedObjectsClient);
  }
  getFakeRequest(headers, spaceId, logger = this.logger) {
    var _this$setupDeps$space3;
    const rawRequest = {
      headers,
      path: '/'
    };
    const fakeRequest = (0, _coreHttpServerUtils.kibanaRequestFactory)(rawRequest);
    const spacesService = (_this$setupDeps$space3 = this.setupDeps.spaces) === null || _this$setupDeps$space3 === void 0 ? void 0 : _this$setupDeps$space3.spacesService;
    if (spacesService) {
      if (spaceId && spaceId !== _common.DEFAULT_SPACE_ID) {
        logger.info(`Generating request for space: ${spaceId}`);
        this.setupDeps.basePath.set(fakeRequest, `/s/${spaceId}`);
      }
    }
    return fakeRequest;
  }

  /*
   * Returns configurable server info
   */
  getServerInfo() {
    const serverInfo = this.http.getServerInfo();
    return {
      basePath: this.http.basePath.serverBasePath,
      hostname: serverInfo.hostname,
      name: serverInfo.name,
      port: serverInfo.port,
      uuid: this.context.env.instanceUuid,
      protocol: serverInfo.protocol
    };
  }
}
exports.ExportType = ExportType;