"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmailNotificationService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _common = require("@kbn/spaces-plugin/common");
var _lib = require("../../lib");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class EmailNotificationService {
  constructor({
    notifications
  }) {
    (0, _defineProperty2.default)(this, "notifications", void 0);
    this.notifications = notifications;
  }
  async getAttachments(reporting, index, id, filename, contentType) {
    const stream = await (0, _lib.getContentStream)(reporting, {
      id,
      index
    });
    const buffers = [];
    for await (const chunk of stream) {
      buffers.push(chunk);
    }
    const content = Buffer.concat(buffers);
    return [{
      content: content.toString('base64'),
      ...(contentType ? {
        contentType
      } : {}),
      filename,
      encoding: 'base64'
    }];
  }
  async notify({
    reporting,
    index,
    id,
    contentType,
    filename,
    relatedObject,
    emailParams
  }) {
    if (!this.notifications.isEmailServiceAvailable()) {
      throw new Error('Email notification service is not available');
    }
    const attachments = await this.getAttachments(reporting, index, id, filename, contentType);
    const {
      to,
      bcc,
      cc,
      subject,
      spaceId
    } = emailParams;
    const message = 'Your scheduled report is attached for you to download or share.';
    await this.notifications.getEmailService().sendAttachmentEmail({
      to,
      bcc,
      cc,
      subject,
      message,
      attachments,
      spaceId: spaceId !== null && spaceId !== void 0 ? spaceId : _common.DEFAULT_SPACE_ID,
      context: {
        relatedObjects: [relatedObject]
      }
    });
  }
}
exports.EmailNotificationService = EmailNotificationService;