"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerInternalPostScheduleRoute = void 0;
var _coreHttpRouterServerInternal = require("@kbn/core-http-router-server-internal");
var _reportingCommon = require("@kbn/reporting-common");
var _common = require("../../../common");
var _request_handler = require("../../../common/request_handler");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  SCHEDULE_PREFIX
} = _reportingCommon.INTERNAL_ROUTES;
const kibanaAccessControlTags = ['generateReport'];
const registerInternalPostScheduleRoute = ({
  logger,
  router,
  reporting
}) => {
  const path = `${SCHEDULE_PREFIX}/{exportType}`;
  router.post({
    path,
    security: {
      authz: {
        requiredPrivileges: kibanaAccessControlTags
      }
    },
    validate: _request_handler.ScheduleRequestHandler.getValidation(),
    options: {
      tags: kibanaAccessControlTags.map(accessControlTag => `access:${accessControlTag}`),
      access: 'internal'
    }
  }, (0, _common.authorizedUserPreRouting)(reporting, async (user, context, req, res) => {
    try {
      const requestHandler = new _request_handler.ScheduleRequestHandler({
        reporting,
        user,
        context,
        path,
        req,
        res,
        logger
      });
      const jobParams = requestHandler.getJobParams();
      const schedule = requestHandler.getSchedule();
      const notification = requestHandler.getNotification();
      return await requestHandler.handleRequest({
        exportTypeId: req.params.exportType,
        jobParams,
        schedule,
        notification
      });
    } catch (err) {
      if (err instanceof _coreHttpRouterServerInternal.KibanaResponse) {
        return err;
      }
      throw err;
    }
  }));
};
exports.registerInternalPostScheduleRoute = registerInternalPostScheduleRoute;