"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PROFILING_FEEDBACK_LINK = void 0;
exports.ProfilingAppPageTemplate = ProfilingAppPageTemplate;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _use_profiling_dependencies = require("../contexts/profiling_dependencies/use_profiling_dependencies");
var _primary_profiling_search_bar = require("./primary_profiling_search_bar");
var _use_local_storage = require("../../hooks/use_local_storage");
var _use_profiling_setup_status = require("../contexts/profiling_setup_status/use_profiling_setup_status");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/profiling/public/components/profiling_app_page_template/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PROFILING_FEEDBACK_LINK = exports.PROFILING_FEEDBACK_LINK = 'https://ela.st/profiling-feedback';
function ProfilingAppPageTemplate({
  children,
  tabs = [],
  hideSearchBar = false,
  noDataConfig,
  restrictWidth = false,
  pageTitle = _i18n.i18n.translate('xpack.profiling.appPageTemplate.pageTitle', {
    defaultMessage: 'Universal Profiling'
  }),
  showBetaBadge = false
}) {
  const {
    start: {
      observabilityShared
    }
  } = (0, _use_profiling_dependencies.useProfilingDependencies)();
  const [privilegesWarningDismissed, setPrivilegesWarningDismissed] = (0, _use_local_storage.useLocalStorage)('profiling.privilegesWarningDismissed', false);
  const {
    profilingSetupStatus
  } = (0, _use_profiling_setup_status.useProfilingSetupStatus)();
  const {
    PageTemplate: ObservabilityPageTemplate
  } = observabilityShared.navigation;
  const history = (0, _reactRouterDom.useHistory)();
  (0, _react.useEffect)(() => {
    window.scrollTo(0, 0);
  }, [history.location.pathname]);
  return /*#__PURE__*/_react.default.createElement(ObservabilityPageTemplate, {
    noDataConfig: noDataConfig,
    pageHeader: {
      'data-test-subj': 'profilingPageTemplate',
      rightSideItems: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        "data-test-subj": "profilingProfilingAppPageTemplateGiveFeedbackButton",
        href: PROFILING_FEEDBACK_LINK,
        target: "_blank",
        color: "warning",
        iconType: "editorComment",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 71,
          columnNumber: 11
        }
      }, _i18n.i18n.translate('xpack.profiling.header.giveFeedbackLink', {
        defaultMessage: 'Give feedback'
      }))],
      pageTitle: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s",
        alignItems: "baseline",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 84,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 85,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement("h1", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 86,
          columnNumber: 15
        }
      }, pageTitle)), showBetaBadge && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 89,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
        label: "Beta",
        color: "hollow",
        tooltipContent: _i18n.i18n.translate('xpack.profiling.header.betaBadgeTooltip', {
          defaultMessage: 'This module is not GA. Please help us by reporting any bugs.'
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 90,
          columnNumber: 17
        }
      }))),
      tabs
    },
    restrictWidth: restrictWidth,
    pageSectionProps: {
      contentProps: {
        style: {
          display: 'flex',
          flexGrow: 1
        }
      }
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    style: {
      maxWidth: '100%'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 7
    }
  }, !hideSearchBar && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    color: "subdued",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_primary_profiling_search_bar.PrimaryProfilingSearchBar, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 15
    }
  }))), (profilingSetupStatus === null || profilingSetupStatus === void 0 ? void 0 : profilingSetupStatus.unauthorized) === true && privilegesWarningDismissed !== true ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "warning",
    title: _i18n.i18n.translate('xpack.profiling.privilegesWarningTitle', {
      defaultMessage: 'User privilege limitation'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.profiling.privilegesWarningDescription', {
    defaultMessage: 'Due to privileges issues we could not check the Universal Profiling status. If you encounter any issues or if data fails to load, please contact your administrator for assistance.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "profilingProfilingAppPageTemplateDismissButton",
    onClick: () => {
      setPrivilegesWarningDismissed(true);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.profiling.dismissPrivilegesCallout', {
    defaultMessage: 'Dismiss'
  })))) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 9
    }
  }, children)));
}