"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.productDocIndexPrefix = exports.productDocIndexPattern = exports.getProductDocIndexName = void 0;
var _is_default_inference_endpoint = require("./is_default_inference_endpoint");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const productDocIndexPrefix = exports.productDocIndexPrefix = '.kibana_ai_product_doc';
const productDocIndexPattern = exports.productDocIndexPattern = `${productDocIndexPrefix}_*`;
const getProductDocIndexName = (productName, inferenceId) => {
  return `${productDocIndexPrefix}_${productName.toLowerCase()}${!(0, _is_default_inference_endpoint.isImpliedDefaultElserInferenceId)(inferenceId) ? `-${inferenceId}` : ''}`;
};
exports.getProductDocIndexName = getProductDocIndexName;