"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VersionOrUndefined = exports.Version = exports.SortOrderOrUndefinedEnum = exports.SortOrderOrUndefined = exports.SortOrUndefined = exports.SnapshotOrUndefined = exports.Snapshot = exports.Shards = exports.SavedQueryIdOrUndefined = exports.SavedQueryId = exports.SavedQueryDescriptionOrUndefined = exports.SavedQueryDescription = exports.RemovedOrUndefined = exports.Removed = exports.QueryOrUndefined = exports.QueryId = exports.Query = exports.QueriesOrUndefined = exports.Queries = exports.PolicyIdsOrUndefined = exports.PolicyIds = exports.PlatformOrUndefined = exports.Platform = exports.PageSizeOrUndefined = exports.PageOrUndefined = exports.PackName = exports.PackIdOrUndefined = exports.PackId = exports.PackDescriptionOrUndefined = exports.PackDescription = exports.ObjectQueriesItem = exports.ObjectQueries = exports.KueryOrUndefined = exports.IntervalOrUndefined = exports.Interval = exports.EnabledOrUndefined = exports.Enabled = exports.ECSMappingOrUndefined = exports.ECSMappingItem = exports.ECSMapping = exports.DefaultSuccessResponse = exports.ArrayQueriesItem = exports.ArrayQueries = void 0;
var _zod = require("@kbn/zod");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Common Osquery Attributes
 *   version: 2023-10-31
 */

/**
 * The ID of the query.
 */

const QueryId = exports.QueryId = _zod.z.string();

/**
 * The pack description.
 */

const PackDescription = exports.PackDescription = _zod.z.string();
const PackDescriptionOrUndefined = exports.PackDescriptionOrUndefined = PackDescription.nullable();

/**
 * Restricts the query to a specified platform. The default is all platforms. To specify multiple platforms, use commas. For example, `linux,darwin`.
 */

const Platform = exports.Platform = _zod.z.string();
const PlatformOrUndefined = exports.PlatformOrUndefined = Platform.nullable();

/**
 * The SQL query you want to run.
 */

const Query = exports.Query = _zod.z.string();
const QueryOrUndefined = exports.QueryOrUndefined = Query.nullable();

/**
 * Uses the Osquery versions greater than or equal to the specified version string.
 */

const Version = exports.Version = _zod.z.string();
const VersionOrUndefined = exports.VersionOrUndefined = Version.nullable();

/**
 * An interval, in seconds, on which to run the query.
 */

const Interval = exports.Interval = _zod.z.string();
const IntervalOrUndefined = exports.IntervalOrUndefined = Interval.nullable();

/**
 * Indicates whether the query is a snapshot.
 */

const Snapshot = exports.Snapshot = _zod.z.boolean();
const SnapshotOrUndefined = exports.SnapshotOrUndefined = Snapshot.nullable();

/**
 * Indicates whether the query is removed.
 */

const Removed = exports.Removed = _zod.z.boolean();
const RemovedOrUndefined = exports.RemovedOrUndefined = Removed.nullable();

/**
 * The pack name.
 */

const PackName = exports.PackName = _zod.z.string();

/**
 * The ID of a saved query.
 */

const SavedQueryId = exports.SavedQueryId = _zod.z.string();
const SavedQueryIdOrUndefined = exports.SavedQueryIdOrUndefined = SavedQueryId.nullable();

/**
 * The saved query description.
 */

const SavedQueryDescription = exports.SavedQueryDescription = _zod.z.string();
const SavedQueryDescriptionOrUndefined = exports.SavedQueryDescriptionOrUndefined = SavedQueryDescription.nullable();

/**
 * The ID of the pack you want to run, retrieve, update, or delete.
 */

const PackId = exports.PackId = _zod.z.string();
const PackIdOrUndefined = exports.PackIdOrUndefined = PackId.nullable();

/**
 * Enables the pack.
 */

const Enabled = exports.Enabled = _zod.z.boolean();
const EnabledOrUndefined = exports.EnabledOrUndefined = Enabled.nullable();

/**
 * A list of agents policy IDs.
 */

const PolicyIds = exports.PolicyIds = _zod.z.array(_zod.z.string());
const PolicyIdsOrUndefined = exports.PolicyIdsOrUndefined = PolicyIds.nullable();
const ECSMappingItem = exports.ECSMappingItem = _zod.z.object({
  /**
   * The ECS field to map to.
   */
  field: _zod.z.string().optional(),
  /**
   * The value to map to the ECS field.
   */
  value: _zod.z.union([_zod.z.string(), _zod.z.array(_zod.z.string())]).optional()
});

/**
 * Map osquery results columns or static values to Elastic Common Schema (ECS) fields
 */

const ECSMapping = exports.ECSMapping = _zod.z.object({}).catchall(ECSMappingItem);
const ECSMappingOrUndefined = exports.ECSMappingOrUndefined = ECSMapping.nullable();
const ArrayQueriesItem = exports.ArrayQueriesItem = _zod.z.object({
  id: QueryId.optional(),
  query: Query.optional(),
  ecs_mapping: ECSMappingOrUndefined.optional(),
  version: VersionOrUndefined.optional(),
  platform: PlatformOrUndefined.optional(),
  removed: RemovedOrUndefined.optional(),
  snapshot: SnapshotOrUndefined.optional()
});

/**
 * An array of queries to run.
 */

const ArrayQueries = exports.ArrayQueries = _zod.z.array(ArrayQueriesItem);
const ObjectQueriesItem = exports.ObjectQueriesItem = _zod.z.object({
  query: Query.optional(),
  id: QueryId.optional(),
  ecs_mapping: ECSMappingOrUndefined.optional(),
  version: VersionOrUndefined.optional(),
  platform: PlatformOrUndefined.optional(),
  saved_query_id: SavedQueryIdOrUndefined.optional(),
  removed: RemovedOrUndefined.optional(),
  snapshot: SnapshotOrUndefined.optional()
});

/**
 * An object of queries.
 */

const ObjectQueries = exports.ObjectQueries = _zod.z.object({}).catchall(ObjectQueriesItem);
const Queries = exports.Queries = _zod.z.union([ArrayQueries, ObjectQueries]);
const QueriesOrUndefined = exports.QueriesOrUndefined = Queries.nullable();

/**
 * The kuery to filter the results by.
 */

const KueryOrUndefined = exports.KueryOrUndefined = _zod.z.string().nullable();

/**
 * The page number to return. The default is 1.
 */

const PageOrUndefined = exports.PageOrUndefined = _zod.z.number().int().nullable();

/**
 * The number of results to return per page. The default is 20.
 */

const PageSizeOrUndefined = exports.PageSizeOrUndefined = _zod.z.number().int().nullable();

/**
 * The field that is used to sort the results.
 */

const SortOrUndefined = exports.SortOrUndefined = _zod.z.string().nullable().default('createdAt');

/**
 * Specifies the sort order.
 */

const SortOrderOrUndefined = exports.SortOrderOrUndefined = _zod.z.enum(['asc', 'desc']);
const SortOrderOrUndefinedEnum = exports.SortOrderOrUndefinedEnum = SortOrderOrUndefined.enum;

/**
 * An object with shard configuration for policies included in the pack. For each policy, set the shard configuration to a percentage (1–100) of target hosts.
 */

const Shards = exports.Shards = _zod.z.object({}).catchall(_zod.z.number());
const DefaultSuccessResponse = exports.DefaultSuccessResponse = _zod.z.object({});