"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createErrorResult = void 0;
exports.getToolResultId = getToolResultId;
exports.isToolResultId = isToolResultId;
var _crypto = require("crypto");
var _onechatCommon = require("@kbn/onechat-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const charset = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz';
const idRegex = /^[a-zA-Z0-9]{6}$/;

/**
 * Generate a random id which can be used for tool result id.
 */
function getToolResultId() {
  return Array.from({
    length: 6
  }, () => charset[(0, _crypto.randomInt)(charset.length)]).join('');
}

/**
 * Check if the provided string is a valid tool result id.
 */
function isToolResultId(id) {
  return idRegex.test(id);
}
const createErrorResult = message => {
  return {
    tool_result_id: getToolResultId(),
    type: _onechatCommon.ToolResultType.error,
    data: typeof message === 'string' ? {
      message
    } : message
  };
};
exports.createErrorResult = createErrorResult;