"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withAgentSpan = withAgentSpan;
var _std = require("@kbn/std");
var _inferenceTracing = require("@kbn/inference-tracing");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function withAgentSpan({
  agent
}, cb) {
  const {
    id: agentId,
    configuration
  } = agent;
  return (0, _inferenceTracing.withActiveInferenceSpan)('ExecuteAgent', {
    attributes: {
      [_inferenceTracing.ElasticGenAIAttributes.InferenceSpanKind]: 'AGENT',
      [_inferenceTracing.ElasticGenAIAttributes.AgentId]: agentId,
      [_inferenceTracing.ElasticGenAIAttributes.AgentConfig]: (0, _std.safeJsonStringify)(configuration)
    }
  }, span => {
    if (!span) {
      return cb();
    }
    const res = cb(span);
    return res.then(agentReturn => {
      var _safeJsonStringify;
      span.setAttribute('output.value', (_safeJsonStringify = (0, _std.safeJsonStringify)(agentReturn)) !== null && _safeJsonStringify !== void 0 ? _safeJsonStringify : 'unknown');
      return agentReturn;
    });
  });
}