"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.runAgent = exports.createAgentHandlerContext = void 0;
var _tracing = require("../../tracing");
var _utils = require("../tools/utils");
var _create_handler = require("../agents/modes/create_handler");
var _utils2 = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createAgentHandlerContext = async ({
  agentExecutionParams,
  manager
}) => {
  const {
    onEvent
  } = agentExecutionParams;
  const {
    request,
    defaultConnectorId,
    elasticsearch,
    modelProviderFactory,
    toolsService,
    resultStore,
    logger
  } = manager.deps;
  return {
    request,
    logger,
    esClient: elasticsearch.client.asScoped(request),
    modelProvider: modelProviderFactory({
      request,
      defaultConnectorId
    }),
    runner: manager.getRunner(),
    toolProvider: (0, _utils.registryToProvider)({
      registry: await toolsService.getRegistry({
        request
      }),
      getRunner: manager.getRunner,
      request
    }),
    resultStore,
    events: (0, _utils2.createAgentEventEmitter)({
      eventHandler: onEvent,
      context: manager.context
    })
  };
};
exports.createAgentHandlerContext = createAgentHandlerContext;
const runAgent = async ({
  agentExecutionParams,
  parentManager
}) => {
  const {
    agentId,
    agentParams,
    abortSignal
  } = agentExecutionParams;
  const context = (0, _utils2.forkContextForAgentRun)({
    parentContext: parentManager.context,
    agentId
  });
  const manager = parentManager.createChild(context);
  const {
    agentsService,
    request
  } = manager.deps;
  const agentRegistry = await agentsService.getRegistry({
    request
  });
  const agent = await agentRegistry.get(agentId);
  const agentResult = await (0, _tracing.withAgentSpan)({
    agent
  }, async () => {
    const agentHandler = (0, _create_handler.createAgentHandler)({
      agent
    });
    const agentHandlerContext = await createAgentHandlerContext({
      agentExecutionParams,
      manager
    });
    return await agentHandler({
      runId: manager.context.runId,
      agentParams,
      abortSignal
    }, agentHandlerContext);
  });
  return {
    result: agentResult.result
  };
};
exports.runAgent = runAgent;