"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.openConversationFlyout = openConversationFlyout;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _public = require("@kbn/kibana-react-plugin/public");
var _conversation_flyout = require("./conversation_flyout");
var _onechat_services_context = require("../application/context/onechat_services_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/flyout/open_conversation_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * Opens a conversation flyout.
 *
 * @param options - Configuration options for the flyout
 * @param params - Internal parameters (services, core, etc.)
 * @returns An object with flyoutRef to close it programmatically
 */
function openConversationFlyout(options, {
  coreStart,
  services,
  startDependencies
}) {
  const {
    overlays,
    application,
    ...startServices
  } = coreStart;

  // Prepare Kibana services context
  const kibanaServices = {
    ...coreStart,
    plugins: startDependencies
  };
  const flyoutRef = overlays.openFlyout((0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: kibanaServices,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_onechat_services_context.OnechatServicesContext.Provider, {
    value: services,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_conversation_flyout.ConversationFlyout, (0, _extends2.default)({}, options, {
    onClose: () => flyoutRef.close(),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 11
    }
  })))), startServices), {
    'data-test-subj': 'onechat-conversation-flyout-wrapper',
    ownFocus: true,
    onClose: () => {
      var _options$onClose;
      flyoutRef.close();
      (_options$onClose = options.onClose) === null || _options$onClose === void 0 ? void 0 : _options$onClose.call(options);
    },
    isResizable: true
  });
  const conversationFlyoutRef = {
    close: () => flyoutRef.close()
  };
  return {
    flyoutRef: conversationFlyoutRef
  };
}