"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnnotationApplyTo = AnnotationApplyTo;
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _sloSchema = require("@kbn/slo-schema");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability/public/pages/annotations/annotation_apply_to.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function AnnotationApplyTo({
  annotation
}) {
  var _annotation$service;
  const slo = annotation.slo;
  const serviceName = (_annotation$service = annotation.service) === null || _annotation$service === void 0 ? void 0 : _annotation$service.name;
  let sloLabel = slo ? _i18n.i18n.translate('xpack.observability.columns.sloTextLabel', {
    defaultMessage: 'SLO: {slo}',
    values: {
      slo: slo.id
    }
  }) : '';
  const isAllSlos = (slo === null || slo === void 0 ? void 0 : slo.id) === _sloSchema.ALL_VALUE;
  if (isAllSlos) {
    sloLabel = _i18n.i18n.translate('xpack.observability.columns.sloTextLabel.all', {
      defaultMessage: 'SLOs: All'
    });
  }
  const serviceLabel = serviceName ? _i18n.i18n.translate('xpack.observability.columns.serviceLabel', {
    defaultMessage: 'Service: {serviceName}',
    values: {
      serviceName
    }
  }) : '';
  if (!slo && !serviceName) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 38,
        columnNumber: 7
      }
    }, _i18n.i18n.translate('xpack.observability.columns.TextLabel', {
      defaultMessage: '--'
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 5
    }
  }, serviceLabel, sloLabel);
}