"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SYNTHETICS_TEMP_DATA_VIEW = void 0;
exports.mapExtraSyntheticsFilters = mapExtraSyntheticsFilters;
var _esQuery = require("@kbn/es-query");
var _synthetics_monitor_status = require("@kbn/response-ops-rule-params/synthetics_monitor_status");
var _synthetics_tls = require("@kbn/response-ops-rule-params/synthetics_tls");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SYNTHETICS_TEMP_DATA_VIEW = exports.SYNTHETICS_TEMP_DATA_VIEW = {
  title: 'synthetics-*',
  timeFieldName: '@timestamp'
};
const supportedAlertParams = Array.from(new Set([..._synthetics_monitor_status.syntheticsMonitorStatusRuleParamsSchema.getSchemaStructure(), ..._synthetics_tls.tlsRuleParamsSchema.getSchemaStructure()].filter(s => s.path.length > 0 && s.path[0] !== 'kqlQuery' && s.path[0] !== 'condition' && s.path[0] !== 'certAgeThreshold' && s.path[0] !== 'certExpirationThreshold' && s.path[0] !== 'search').map(s => s.path[0]).sort()));
const fieldMap = {
  locations: 'observer.name',
  monitorIds: 'monitor.id',
  monitorTypes: 'monitor.type',
  projects: 'project.id',
  tags: 'tags'
};
function getFieldnameForKey(key) {
  return fieldMap[key];
}
function listToKqlNode(fieldname, list) {
  if (list.length === 0) {
    throw new Error(`Alert params ${fieldname !== null && fieldname !== void 0 ? fieldname : 'field'} must be a non-empty array`);
  }
  return _esQuery.nodeBuilder.or(list.map(item => _esQuery.nodeBuilder.is(fieldname, item)));
}
function mapExtraSyntheticsFilters(extraFilters, kqlQuery) {
  const filters = [];
  if (kqlQuery) {
    filters.push((0, _esQuery.fromKueryExpression)(kqlQuery));
  }
  filters.push(...supportedAlertParams.filter(key => Array.isArray(extraFilters[key]) && extraFilters[key].length > 0).map(key => listToKqlNode(getFieldnameForKey(key), extraFilters[key])));
  return filters;
}